/****************************************************************************
 *
 * All portions copyright their respective authors.  All rights reserved.
 *
 * This file is part of IVMan (ivm).
 *
 * This file may be distributed under the terms of the Q Public License
 * as defined by Troll Tech AS of Norway and appearing in the file
 * LICENSE.QPL included in the packaging of this file.
 * 
 * See http://www.troll.no/qpl for QPL licensing information.
 *
 * $Id: IvmConfigCommon.h,v 1.2 2005/05/12 01:42:34 ro_han Exp $
 *****************************************************************************/

// Some operations more than one IvmConfig* needs to use.

#include "common.h"

#include <glib.h>
#include <libxml/xmlstring.h>

// Returns whether or not the device given by udi has a property
// with name 'property' (excluding first four 'hal.' characters) and
// value 'value'.
gboolean hal_xml_property_matches(xmlChar const *const property,
                                  xmlChar const *const value,
                                  char const *udi);

// Returns whether or not the device is mountable.
gboolean ivm_device_is_mountable(char const *udi);
