use strict;
use Net::SNMP;
use vars qw($VERSION %IRSSI);

$VERSION = "1.10";
%IRSSI = (
	authors => "Rick (strlen) Jansen",
	contact => "strlen\@shell.nl",
	name => "snmpup",
	description => "This script queries a remote host (/snmpup <remote_host>) running snmpd for it's uptime",
	license => "GPL/1",
	changed => "Wed Mar 13 09:47:41 CET 2002"
);

use Irssi;
sub snmpup {
	my ($hostname, $server,$data) = @_;
	my ($session, $error) = Net::SNMP->session(
				-hostname	=>	$hostname,
				-community	=>	'public',
				-port		=>	'161',
				);
	if (!defined($session)) {
		$server->command("/msg ".$data->{name}." Unable to create SNMP connection: $error");
		return;
	}
	my $hostUpTime = '1.3.6.1.2.1.25.1.1.0';
	my $sysSystem = '1.3.6.1.2.1.1.1.0';
	my $result = $session->get_request(
				-varbindlist	=> [	$sysSystem,
							$hostUpTime]
				);
	if (!defined($result)) {
		my $err = $session->error;
		$server->command("/msg ".$data->{name}." SNMP get error: $err");
		$session->close();
	} else {
		my $host = $session->hostname; 
		my $system = $result->{$sysSystem};
		my $uptime = $result->{$hostUpTime};
		$server->command("/msg ".$data->{name}." SNMP uptime for host '$host' is $uptime");
		$session->close();
	}
	$session->close();
}
Irssi::command_bind("snmpup","snmpup");
