#!/usr/bin/perl -w
# $Id: randaway.pl,v 1.8 2002/03/25 20:16:29 lkarsten Exp $
# Irssi script for random away-messages.
#
# "written" by scn/EFNET, march 2002. 
# Based on simular script written by c0ffee.
#
# adds /raway, /awayadd, /awayreasons and /awayreread.
#  
# $Log: randaway.pl,v $
# Revision 1.8  2002/03/25 20:16:29  lkarsten
# *** empty log message ***
#
# Revision 1.7  2002/03/24 04:13:57  lkarsten
# almost ready!
#
#
#

use Irssi;
use Irssi::Irc;

$VERSION = "0.1";
%IRSSI = (
    authors	=> "scn",
    contact	=> "lkarsten\@stud.ntnu.no",
    name 	=> "randaway.pl",
    description => "Random away-messages",
    license	=> "Public Domain",
    url		=> "http://www.stud.ntnu.no/~lkarsten/irssi/",
);

# file to read random reasons from. It should contain one
# reason at each line, empty lines and lines starting with # is 
# skipped.
$reasonfile = "$ENV{HOME}/.irssi/awayreasons";

my @awayreasons;

sub readreasons {
        undef @awayreasons;
        if (-f $reasonfile) { 
                Irssi::print("=> Trying to read awayreasons from $reasonfile");
		open F, $reasonfile;

		# this actually makes the while() work like a while and not
		# like a read() .. ie, stopping at each \n.
		local $/ = "\n";
                while (<F>) {
		    $reason = $_;

		    # remove any naughty linefeeds.
		    chomp($reason);
		    
		    # skips reason if it's an empty line or line starts with #
		    if ($reason =~ /^$/ ) { next; }
		    if ($reason =~ /^#/ ) { next; }
		    
		    #Irssi::print("\"$reason\"");
		    
		    # adds to array.
		    push(@awayreasons, $reason); 
                }
                close F; 
                Irssi::print("=> Read " . scalar(@awayreasons) . " reasons.");
        } else {
	    # some default away-reasons.
	    Irssi::print("Unable to find $reasonfile, no reasons loaded.");
	    push(@awayreasons, "i\'m pretty lame!");
	    push(@awayreasons, "i think i forgot something!"); 
	};  
}

sub cmd_away {
    # only do our magic if we're not away already. 
    if (Irssi::active_server()->{usermode_away} == 0) {
	my ($reason) = @_;
	# using supplied reason if .. eh, supplied, else find a random one if not.
	if (!$reason) { $reason = $awayreasons[rand @awayreasons]; }
	Irssi::print("awayreason used: $reason");
	Irssi::command ("away $reason");
    } else {
	Irssi::print("you're already away");
    }
} 

sub add_reason {
    my ($reason) = @_;
    if (!$reason) {
        Irssi::print("Refusing to add empty reason.");
    } else {
	chomp($reason);
	# adding to current environment.
	push(@awayreasons, $reason);
	# and also saving it for later.  
	open(F, ">> $reasonsfile");
	print F $reason;
	close F;
	Irssi::print("Added: $reason");
    }
}

sub reasons {
    Irssi::print("Listing current awayreasons");
    foreach $var (@awayreasons) {
        Irssi::print("=> \"$var\""); 
    }
}

# -- main program --

readreasons();
Irssi::command_bind('raway', 'cmd_away');
Irssi::command_bind('rawayreread', 'readreasons');
Irssi::command_bind('rawayadd', 'add_reason');
Irssi::command_bind('rawayreasons', 'reasons');

# -- end of script --
