# name        Ignore-OC
#
# authors     Erkki Seppl, bd@bc-bd.org
# contact     flux@inside.org, bd@bc-bd.org
# description Ignore messages from people not on your channels
#
#
# 0.3
#	bd@bc-bd.org
#		- added command: ignoretoggle to en/disable the ignoring on the fly
#		- added setting: ignore_log
#			* ON  : log ignored messages to the statuswindow
#			* OFF : discard ignored messages
#
# 0.2
#	bd@bc-bd.org
#		- removed #!/usr/bin/perl
#		- fixed sending notices to wrong server
#		- fixed ignoring wrong people 

use Irssi;
use vars qw($VERSION %IRSSI);

$VERSION = "0.3";
%IRSSI = (
    authors     => "Erkki Seppl, bd\@bc-bd.org",
    contact     => "flux\@inside.org, bd\@bc-bd.org",
    name        => "Ignore-OC",
    description => "Ignore messages from people not on your channels",
    license     => "Public Domain",
    url         => "http://xulfad.inside.org/~flux/software/irssi/",
    changed     => "Sun Jan 27 19:07:00 CET 2002"
);

my ($ignoring);

$ignoring = 1;

sub sig_message_private {
  my ($server, $message, $nick, $address) = @_;
  my $channel;

  if ($message =~ m/oc:/i) {
    return 1;
  }

  foreach $channel (Irssi::channels()) {
    foreach my $other ($channel->nicks()) {
      if ($other->{nick} eq $nick) {
        return 1;
      }
    }
  }
  
  if (Irssi::settings_get_bool('ignore_log') == 1) {
  	Irssi::print("ignored: '".$message."' from (".$nick.") on '".$server->{chatnet}."'");
  }
  
  $server->command("NOTICE $nick You're not on any channel I'm on, thus, due to spambots, your message was ignored. Prefix your message with 'OC:' to bypass the ignore.");
  Irssi::signal_stop();
}

sub cmd_ignoreToggle {
	my ($data, $server, $channel) = @_;

	if ($ignoring) {
		$ignoring = 0;
		Irssi::signal_remove("message private", "sig_message_private");
		$channel->print("No longer ignoring people outside my channels");
	} else {
		$ignoring = 1;
		Irssi::signal_add("message private", "sig_message_private");
		$channel->print("Ignoring people outside my channels");
	}
}

Irssi::signal_add("message private", "sig_message_private");

Irssi::command_bind('ignoretoggle', 'cmd_ignoreToggle');

Irssi::settings_add_bool('misc', 'ignore_log', 1);
