# $Id: exec-clean.pl,v 1.1.1.1 2002/02/13 06:24:50 root Exp $

use Irssi 20020121.2020 ();
$VERSION = "0.01";
%IRSSI = (
	  authors     => 'Jean-Yves "decadix" Lefort',
	  contact     => 'jylefort\@brutele.be, decadix on IRCNet',
	  name        => 'exec-clean',
	  description => 'Adds a setting to automatically terminate a process whose parent window has been closed',
	  license     => 'BSD',
	  changed     => '$Date: 2002/02/13 06:24:50 $ ',
);

# /set's:
#
#	autokill_orphan_processes
#
#		guess :)
#
# changes:
#
#	2002-01-28	initial release
#
# todo:
#
#	* kill the process using a better method (TERM -> sleep -> KILL etc)

use strict;
use Irssi::UI;

sub window_destroyed {
  my ($window) = @_;

  foreach (Irssi::UI::processes()) {
    if ($_->{target_win}->{refnum} == $window->{refnum}
	&& Irssi::settings_get_bool("autokill_orphan_processes")) {
      kill 15, $_->{pid};
      return;
    }
  }
}

Irssi::signal_add("window destroyed", "window_destroyed");
Irssi::settings_add_bool("misc", "autokill_orphan_processes", 1);
