#!/usr/bin/perl -w

# BlowJob 0.8.3, a crypto script - ported from xchat
# was based on rodney mulraney's crypt
# changed crypting method to Blowfish+Base64+randomness+Z-compression
# needs :
#         Crypt::CBC,
#         Crypt::Blowfish,
#         MIME::Base64,
#         Compress::Zlib
#
# crypted format is :
# HEX(Base64((paranoia-factor)*(blowfish(RANDOM+Zcomp(string))+RANDOM)))
#
# 06-12-2001 Added default umask for blowjob.keys
# 05-12-2001 Added paranoia support for each key
# 05-12-2001 Added conf file support
# 05-12-2001 Added delkey and now can handle multi-server/channel keys
# 05-12-2001 permanent crypting to a channel added
# 05-12-2001 Can now handle multi-channel keys
# just /setkey <key> on the channel you are to associate a channel with a key
#
# --- conf file format ---
#
# # the generic key ( when /setkey has not been used )
# key:            generic key value
# # header that marks a crypted sentance
# header:         {header}
# # do you wan't to see crypted lines [yes|no]
# showcrypt:      yes
# # enable wildcards for multiserver entries ( useful for OPN for example )
# wildcardserver: yes
#
# --- end of conf file ---
#
# iMil <imil@gcu-squad.org>
# skid <skid@gcu-squad.org>
# Foxmask <odemah@gcu-squad.org>

use Crypt::CBC;
use Crypt::Blowfish;
use MIME::Base64;
use Compress::Zlib;

use Irssi::Irc;
use Irssi;
use vars qw($VERSION %IRSSI);

$VERSION = "0.8.3";
%IRSSI = (
    authors => 'Imil,Skid,Foxmask',
    contact => 'Imil@gcu-squad.org,skid@gcu-squad.oprg,odemah@phpfr.org ',
    name => 'blowjob',
    description => 'crypt everything you say in every channel you want with your friends',
    license => 'GNU GPL',
    url => 'http://team.gcu-squad.org/~odemah/',
);


############# IRSSI README AREA #################################
#To install this script just do
#/script load blowjob-irssi
#  and
#/blowhelp
#  to read all the complete feature of the script :)
#To uninstall it do
#/script unload blowjob-irssi
################################################################


my $key = 'very poor key' ;
my $header = "{blow} ";
# Crypt loops, 1 should be enough for everyone imho ;)
# please note with a value of 4, a single 4-letter word can generate
# a 4 line crypted sentance
my $paranoia = 1;
# set this to "no" if you don't want to see crypted lines
my $seecrypt = "no";
# add a server mask by default ?
my $enableWildcard="yes";

my $alnum = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";

my $gkey;
sub loadconf
{
  my $fconf="$ENV{HOME}/.irssi/blowjob.conf";
  my @conf;
  open (CONF, "<$fconf");

  if (!( -f CONF)) {
    Irssi::print("\00305> $fconf not found, setting to defaults\n");
    Irssi::print("\00305> creating $fconf with default values\n\n");
    close(CONF);
    open(CONF,">$fconf");
    print CONF "key:			$key\n";
    print CONF "header:			$header \n";
    print CONF "seecrypt:		$seecrypt\n";
    print CONF "wildcardserver:		$enableWildcard\n";
    close(CONF);
    return 1;
  }

  @conf=<CONF>;
  close(CONF);

  my $current;
  foreach(@conf) {
    $current = $_;
    $current =~ s/\n//g;
    if ($current =~ m/key/) {
      $current =~ s/.*\:[\ \t]*//;
      $key = $current;
      $gkey = $key;
    }
    if ($current =~ m/header/) {
      $current =~ s/.*\:[\ \t]*//;
      $header = $current;
    }
    if ($current =~ m/seecrypt/) {
      $current =~ s/.*\:[\ \t]*//;
      $seecrypt = $current;
    }
    if ($current =~ m/wildcardserver/) {
      $current =~ s/.*\:[\ \t]*//;
      $enableWildcard = $current;
    }
  }
  Irssi::print("\00314- configuration file loaded\n");
  return 1;
}
loadconf;

my $kfile ="$ENV{HOME}/.irssi/blowjob.keys";
my @keys;
$gkey=$key;
my $gparanoia=$paranoia;

sub loadkeys
{
  if ( -e "$kfile" ) {
    open (KEYF, "<$kfile");
    @keys = <KEYF>;
    close (KEYF);
  }
  Irssi::print("\00314- keys reloaded (Total:\00315 ".scalar @keys."\00314)\n");
  return 1;
}
loadkeys;

sub getkey
{
  my ($data, $curserv, $curchan) = @_;

  my $gotkey=0;
  my $serv;
  my $chan;
  my $fkey;

  foreach(@keys) {
    s/\n//g;
    ($serv,$chan,$fkey,$fparanoia)=split /:/;
    if ( $curserv =~ /$serv/ and $curchan =~ /^$chan$/ ) {
      $key= $fkey;
      $paranoia=$fparanoia;
      $gotkey=1;
    }
  }
  if (!$gotkey) {
    $key=$gkey;
    $paranoia=$gparanoia;
  }
  $cipher=new Crypt::CBC($key,'Blowfish',$ks);
}

sub setkey
{
  my ($data, $server, $channel) = @_;
  my $curchan = $channel->{name};
  my $curserv = $server->{address};
  # my $key = $data;

  my $fparanoia;

  my $newchan=1;
  umask(0077);
  unless ($_[0] =~ /( +\d$)/) {
     $_[0].= " $gparanoia";
  }
  ($key, $fparanoia) = ($_[0] =~ /(.*) +(\d)/);

  if($enableWildcard =~ /[Yy][Ee][Ss]/) {
      $curserv =~ s/(.*?)\./(.*?)\./;
    Irssi::print("\00314IRC server wildcards enabled\n");
  }

  my $line="$curserv:$curchan:$key:$fparanoia";

  open (KEYF, ">$kfile");
  foreach(@keys) {
    s/\n//g;
    if (/^$curserv\:$curchan\:/) {
      print KEYF "$line\n";
      $newchan=0;
    } else {
      print KEYF "$_\n";
    }
  }
  if ($newchan) {
    print KEYF "$line\n";
  }
  close (KEYF);
  loadkeys;
  Irssi::active_win()->print("\00314key set to \00315$key\00314 for channel \00315$curchan");
  return 1 ;
}

sub delkey
{
  my ($data, $server, $channel) = @_;
  my $curchan = $channel->{name};
  my $curserv = $server->{address};

  my $serv;
  my $chan;

  open (KEYF, ">$kfile");
  foreach(@keys) {
    s/\n//g;
    ($serv,$chan)=/^(.*?)\:(.*?)\:/;
   unless ($curserv =~ /$serv/ and $curchan=~/^$chan$/) {
      print KEYF "$_\n";
    }
  }
  close (KEYF);
  Irssi::active_win()->print("\00314key for channel \00315$curchan\00314 deleted");
  loadkeys;
  return 1 ;
}

sub showkey {
  my ($data, $server, $channel) = @_;
  my $curchan = $channel->{name};
  my $curserv = $server->{address};

  getkey($data,$curserv,$curchan);

  Irssi::active_win()->print("\00314current key is : \00315$key");
  return 1 ;
}

sub blow
{
  my ($data, $server, $channel) = @_;
  my $in = $data ;
  my $nick = $server->{nick};
  my $curchan = $channel->{name};
  my $curserv = $server->{address};
  my $prng1="";
  my $prng2="";

  for ($i=0;$i<4;$i++) {
    $prng1.=substr($alnum,int(rand(61)),1);
    $prng2.=substr($alnum,int(rand(61)),1);
  }

  getkey($data,$server,$curchan);
  Irssi::active_win()->print("<$nick|{crypted}> \00310$in");

  $cipher->start('encrypting');

  $in = compress($in);
  my $i;
  for ($i=0;$i<$paranoia;$i++) {
    $in = $prng1.$in;
    $in = $cipher->encrypt($in);
    $in .= $prng2;
    # don't wan't to see "RandomIV"
    $in =~ s/^.{8}//;
  }
  $in = encode_base64($in);
  $in = unpack("H*",$in);
  $in = $header.$in;
  $in =~ s/=+$//;

  $server->command("/msg -$server->{tag} $curchan $in");
  if ($seecrypt =~ m/[Yy][Ee][Ss]/) {
    $server->print($channel,"\00315$in", MSGLEVEL_CLIENTCRAP);
  }
  $cipher->finish;
  return 1 ;
}

sub infoline
{
  my ($server, $data, $nick, $address) = @_;
  my ($channel, $text) = $data =~ /^(\S*)\s:(.*)/;
  my $msgline = $text;
  my $msgnick = $server->{nick};

  my $curchan = $channel->{name};
  my $curserv = $server->{address};

  if ($msgline =~ m/^$header/) {
    my $out = $msgline;
    $out =~ s/\0030[0-9]//g;
    $out =~ s/$header//g;

    getkey($data,$curserv,$curchan);

    $cipher->start('decrypting');
    $out = pack("H*",$out);
    $out = decode_base64($out);

    my $i;
    for ($i=0;$i<$paranoia;$i++) {
      $out = substr($out,0,(length($out)-4));
      # restore RandomIV
      $out = 'RandomIV'.$out;
      $out = $cipher->decrypt($out);
      $out = substr($out,4);
    }
    $out = uncompress($out);

    $server->print($channel, "<$msgnick|{uncrypted}> \00311$out", MSGLEVEL_CLIENTCRAP);
    $cipher->finish;
    if ($seecrypt =~ m/[Yy][Ee][Ss]/) {
      $server->print($channel, "\00315<$msgnick> $msgline", MSGLEVEL_CLIENTCRAP);
    }
    return 1;
  }
  return 0 ;
}

my $permchans='';
sub perm
{
   my ($data, $server, $channel) = @_;
   my $curchan = $channel->{name};

  if ($permchans =~ m/$curchan/) {
    $permchans =~ s/$curchan\://;
    Irssi::active_win()->print("\00314not crypting to \00315$curchan\00314 anymore");
  } else {
    $permchans .= $curchan.':';
    Irssi::active_win()->print("\00314crypting to \00315$curchan");
  }
  return 1;
}
sub myline
{
  my ($data, $server, $channel) = @_;
  my $curchan = $channel->{name};
  if ($permchans =~ m/$curchan/) {
    my $line = shift;
    blow($line);
    return 1;
  }
}

sub help
{
  Irssi::print("\00314[\00303bl\003090\00303wjob\00314]\00315 script :\n");
  Irssi::print("\00315/setkey <newkey> [<paranoia>] :\00314 new key for current channel\n") ;
  Irssi::print("\00315/delkey                       :\00314 delete key for current channel");
  Irssi::print("\00315/showkey                      :\00314 show your current key\n") ;
  Irssi::print("\00315/blow   <line>                :\00314 send crypted line\n") ;
  Irssi::print("\00315/perm                         :\00314 flag current channel as permanently crypted\n") ;
  Irssi::print("\00315/bconf                        :\00314 reload blowjob.conf\n") ;

  return 1 ;
}

Irssi::print("blowjob script $VERSION") ;
Irssi::print("\n\00314[\00303bl\003090\00303wjob\00314] v$version\00315 script loaded\n\n");
Irssi::print("\00314- type \00315/blowhelp\00314 for options\n") ;
Irssi::print("\00314- paranoia level is      : \00315$paranoia\n") ;
Irssi::print("\00314- generic key is         : \00315$key\n") ;
Irssi::print("\n\00314* please read script itself for documentation\n");
Irssi::signal_add("event privmsg","infoline") ;
Irssi::command_bind("blowhelp","help") ;
Irssi::command_bind("setkey","setkey") ;
Irssi::command_bind("delkey","delkey");
Irssi::command_bind("blow","blow") ;
Irssi::command_bind("showkey","showkey") ;
Irssi::command_bind("perm","perm") ;
Irssi::command_bind("bconf","loadconf") ;
Irssi::command_bind("","myline") ;
