/*
 * This program is original work by San Mehat <nettwerk@valinux.com> .
 * This program is distributed under the GNU General Public License (GPL)
 * as outlined in the COPYING file.
 *
 * Copyright (C) 1999, San Mehat, and VA Linux Systems
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */
#ifndef _SDR_H
#define _SDR_H

typedef struct	sdr_repository_info_response
	{
	unsigned char		sdr_major_version	:4						__attribute__ ((packed));
	unsigned char		sdr_minor_version	:4						__attribute__ ((packed));
	unsigned short	record_count										__attribute__ ((packed));
	unsigned short	free_space											__attribute__ ((packed));
	unsigned int		most_recent_addition						__attribute__ ((packed));
	unsigned int		most_recent_erase								__attribute__ ((packed));
	unsigned char		supports_get_sdr_alloc_info	:1	__attribute__	((packed));
	unsigned char		supports_reserve_sdr				:1	__attribute__ ((packed));
	unsigned char		supports_partial_add_sdr		:1	__attribute__	((packed));
	unsigned char		supports_delete_sdr					:1	__attribute__	((packed));
	unsigned char		reserved										:3	__attribute__	((packed));
	unsigned char		supports_overflow_flag			:1	__attribute__	((packed));
	} SDR_REPOSITORY_INFO_RESPONSE;

typedef struct	sdr_repository_allocation_info_response
	{
	unsigned short	possible_allocation_units				__attribute__	((packed));
	unsigned short	allocation_unit_size						__attribute__	((packed));
	unsigned short	num_free_allocation_units				__attribute__	((packed));
	unsigned short	largest_free_block							__attribute__	((packed));
	unsigned char		maximum_record_size							__attribute__	((packed));
	} SDR_REPOSITORY_ALLOCATION_INFO_RESPONSE;

typedef struct reserve_sdr_repository_response
	{
	unsigned short	res_id													__attribute__	((packed));	
	} RESERVE_SDR_REPOSITORY_RESPONSE;

typedef struct	get_sdr_request
	{
	unsigned short	reservation_id									__attribute__	((packed));
	unsigned short	record_id												__attribute__	((packed));
	unsigned char		offset_into_record							__attribute__	((packed));
	unsigned char		bytes_to_read										__attribute__	((packed));
	} GET_SDR_REQUEST;

typedef struct analog_sensor_reading_response
	{
	unsigned	char	reading													__attribute__	((packed));

	unsigned	char	thres_cmp_above_uc					:1	__attribute__	((packed));
	unsigned	char	thres_cmp_below_lc					:1	__attribute__	((packed));
	unsigned	char	thres_cmp_above_unc					:1	__attribute__	((packed));
	unsigned	char	thres_cmp_below_lnc					:1	__attribute__	((packed));
	unsigned	char	thres_cmp_above_unr					:1	__attribute__	((packed));
	unsigned	char	thres_cmp_below_unr					:1	__attribute__	((packed));
	unsigned	char	sensor_disabled							:1	__attribute__	((packed));
	} ANALOG_SENSOR_READING_RESPONSE;

typedef struct digital_sensor_reading_response
	{
	unsigned	char	digital_status_offset				:1	__attribute__	((packed));
	unsigned	char	reserved0										:5	__attribute__	((packed));
	unsigned	char	sensor_disabled							:1	__attribute__	((packed));
	unsigned	char	reserved1										:1	__attribute__	((packed));
	} DIGITAL_SENSOR_READING_RESPONSE;

typedef struct discrete_sensor_reading_response
	{
	unsigned	char	event_mask_lsb									__attribute__	((packed));

	unsigned	char	event_mask_msb							:7	__attribute__	((packed));
	unsigned	char	sensor_disabled							:1	__attribute__	((packed));

	unsigned	char	most_recent_event_offset		:4	__attribute__	((packed));
	unsigned	char	reserved										:4	__attribute__	((packed));
	} DISCRETE_SENSOR_READING_RESPONSE;

typedef struct sdr_header
	{
	/*
	 * Sensor Record Header 
	 */
	unsigned short	record_id												__attribute__	((packed));

	unsigned	char	sdr_major_version	:4						__attribute__	((packed));
	unsigned	char	sdr_minor_version	:4						__attribute__	((packed));

	unsigned	char	record_type											__attribute__	((packed));	
	unsigned	char	record_length										__attribute__	((packed));
	} SDR_HEADER;

	/*
	 * Type 0x01, Internal sensor with thresholds (body bytes)
	 */
typedef struct	type_01
	{
	/*
	 * Sensor Record Header 
	 */
	unsigned short	record_id												__attribute__	((packed));

	unsigned	char	sdr_major_version	:4						__attribute__	((packed));
	unsigned	char	sdr_minor_version	:4						__attribute__	((packed));

	unsigned	char	record_type											__attribute__	((packed));	
	unsigned	char	record_length										__attribute__	((packed));
	/*
	 * Sensor Key
	 */
	unsigned	char	id_type						:1						__attribute__	((packed));	
	unsigned	char	id								:7						__attribute__	((packed));

	unsigned	char	sensor_owner_lun	:2						__attribute__	((packed));
	unsigned	char	res1							:2						__attribute__	((packed));
	unsigned 	char	fru_owner_lun			:2						__attribute__	((packed));
	unsigned	char	res2							:2						__attribute__	((packed));

	unsigned	char	sensor_number										__attribute__	((packed));

	/*
	 * Body bytes
	 */
	unsigned	char	sensor_owner_confirm_device_id		__attribute__	((packed));
	unsigned	char	sensor_owner_confirm_fw_revision	__attribute__	((packed));

	unsigned	char	fru_inv_device_owner_id				:7	__attribute__	((packed));
	unsigned	char	fru_inv_device_owner_id_type	:1	__attribute__	((packed));

	unsigned	char	sensor_scanning_enabled				:1	__attribute__	((packed));
	unsigned	char	event_generation_enabled			:1	__attribute__	((packed));
	unsigned	char	res3													:2	__attribute__	((packed));
	unsigned	char	threshold_init_required				:1	__attribute__	((packed));
	unsigned	char	init_event_messages						:1	__attribute__	((packed));
	unsigned	char	init_scanning									:1	__attribute__	((packed));
	unsigned	char	sensor_init										:1	__attribute__	((packed));

	#define					PER_THRESHOLD_SHUTDOWN								0x00
	#define					ENTIRE_SENSOR_ONLY										0x01
	#define					GLOBAL_DISABLE_ONLY										0x02
	#define					NO_EVENTS_FROM_SENSOR									0x03
	unsigned	char	sens_capable_event_msg_shutdown	:2	__attribute__	((packed));	
	#define					NO_EVENT_MSG_GENERATION								0x00
	#define					EVENT_MSG_GEN_TYPE_NOT_SPECIFIED			0x01
	#define					PER_TYPE_CODE_AND_EVENT_TRIGGER_MASK	0x02
	#define					RES1																	0x03
	unsigned	char	sens_capable_event_msg_gen			:2	__attribute__	((packed));
	#define					NO_PRESENT_READING_SUPPORT						0x00
	#define					PRESENT_READING_TYPE_NOT_SPECIFIED		0x01
	#define					DIGITAL_DISCRETE											0x02
	#define					ANALOG																0x03
	unsigned	char	sens_capable_reading_type				:2	__attribute__	((packed));
	unsigned	char	sens_capable_auto_rearm					:1	__attribute__	((packed));
	unsigned	char	sens_capable_hysterisis_setable	:1	__attribute__	((packed));

	unsigned	char	sensor_type													__attribute__	((packed)); 
	unsigned	char	event_reading_type_code							__attribute__	((packed));
	unsigned	short	event_trigger_mask									__attribute__	((packed));
	unsigned	short	event_reading_mask									__attribute__	((packed));

	unsigned	char	sensor_units_1_percentage				:1	__attribute__	((packed));	
	#define					MODIFIER_NONE													0x00
	#define					BASIC_UNIT_DIV_MODIFIER_UNIT					0x01
	#define					BASIC_UNIT_MUL_MODIFIER_UNIT					0x02
	#define					RES2																	0x03
	unsigned	char	sensor_units_1_modifier_unit		:2	__attribute__	((packed));
	#define					RATE_NONE															0x00
	#define					RATE_US																0x01
	#define					RATE_MS																0x02
	#define					RATE_S																0x03
	#define					RATE_MINUTE														0x04
	#define					RATE_HOUR															0x05
	#define					RATE_DAY															0x06
	#define					RATE_RESERVED													0x07
	unsigned	char	sensor_units_1_rate_unit				:3	__attribute__	((packed));
	#define					FORMAT_UNSIGNED												0x00
	#define					FORMAT_ONES_COMPLIMENT								0x01
	#define					FORMAT_TWOS_COMPLIMENT								0x02
	#define					FORMAT_RESERVED												0x03
	unsigned	char	sensor_units_1_raw_data_format	:2	__attribute__	((packed));

	unsigned	char	sensor_units_2_base_unit						__attribute__	((packed));
	unsigned	char	sensor_units_3_modifier_unit				__attribute__	((packed));

	#define					LINEARIZATION_LINEAR									0x00
	#define					LINEARIZATION_LN											0x01
	#define					LINEARIZATION_LOG10										0x02
	#define					LINEARIZATION_LOG2										0x03
	#define					LINEARIZATION_E												0x04
	#define					LINEARIZATION_EXP10										0x05
	#define					LINEARIZATION_EXP2										0x06
	#define					LINEARIZATION_1_DIV_X									0x07
	#define					LINEARIZATION_SQR_X										0x08
	#define					LINEARIZATION_CUBE_X									0x09
	#define					LINEARIZATION_SQRT_X									0x0A
	#define					LINEARIZATION_CUBE_MINUS_1_X					0x0B
	unsigned	char	linearization										:7	__attribute__	((packed));	
	unsigned	char	res44														:1  __attribute__ ((packed));

	char						M_ls8bits												:8	__attribute__	((packed));	

	unsigned	char	M_tolerance											:6	__attribute__	((packed)); 
	char						M_ms2bits												:2	__attribute__	((packed));

	char						B_ls8bits												:8	__attribute__	((packed)); 

	unsigned	char	accuracy_ls6bits								:6	__attribute__	((packed)); 
	char						B_ms2bits												:2	__attribute__	((packed));

	unsigned	char	res4														:2	__attribute__	((packed)); 
	unsigned	char	accuracy_exp										:2	__attribute__	((packed));
	unsigned	char	accuracy_ms4bits								:4	__attribute__	((packed));

	char						B_exp														:4	__attribute__	((packed));	
	char						R_exp														:4	__attribute__	((packed));

	unsigned	char	nominal_reading_specified				:1	__attribute__	((packed)); 
	unsigned	char	normal_max_specified						:1	__attribute__	((packed));
	unsigned	char	normal_min_specified						:1	__attribute__	((packed));
	unsigned	char	res5														:5	__attribute__	((packed));

	unsigned	char	nominal_reading											__attribute__	((packed)); 
	unsigned	char	normal_maximum											__attribute__	((packed)); 
	unsigned	char	normal_minimum											__attribute__	((packed)); 
	unsigned	char	sensor_maximum_reading							__attribute__	((packed)); 
	unsigned	char	sensor_minimum_reading							__attribute__	((packed)); 

	unsigned	char	read_thres_mask_lower_non_crit	:1	__attribute__	((packed)); 
	unsigned	char	read_thres_mask_lower_crit			:1	__attribute__	((packed));
	unsigned	char	read_thres_mask_lower_non_recov	:1	__attribute__	((packed));
	unsigned	char	read_thres_mask_upper_non_crit	:1	__attribute__	((packed));
	unsigned	char	read_thres_mask_upper_crit			:1	__attribute__	((packed));
	unsigned	char	read_thres_mask_upper_non_recov	:1	__attribute__	((packed));
	unsigned	char	read_thres_mask_lower_res1			:1	__attribute__	((packed));
	unsigned	char	read_thres_mask_lower_res2			:1	__attribute__	((packed));

	unsigned	char	set_thres_mask_lower_non_crit		:1	__attribute__	((packed)); 
	unsigned	char	set_thres_mask_lower_crit				:1	__attribute__	((packed));
	unsigned	char	set_thres_mask_lower_non_recov	:1	__attribute__	((packed));
	unsigned	char	set_thres_mask_upper_non_crit		:1	__attribute__	((packed));
	unsigned	char	set_thres_mask_upper_crit				:1	__attribute__	((packed));
	unsigned	char	set_thres_mask_upper_non_recov	:1	__attribute__	((packed));
	unsigned	char	set_thres_mask_lower_res1				:1	__attribute__	((packed));
	unsigned	char	set_thres_mask_lower_res2				:1	__attribute__	((packed));
	
	unsigned	char	upper_non_recoverable								__attribute__	((packed)); 
	unsigned	char	upper_critical											__attribute__	((packed)); 
	unsigned	char	upper_non_critical									__attribute__	((packed)); 
	unsigned	char	lower_non_recoverable								__attribute__	((packed)); 
	unsigned	char	lower_critical											__attribute__	((packed)); 
	unsigned	char	lower_non_critical									__attribute__	((packed));
	unsigned	char	positive_hysterisis									__attribute__	((packed)); 
	unsigned	char	negative_hysterisis									__attribute__	((packed)); 
	unsigned	char	oem																	__attribute__	((packed)); 
	unsigned	char	entity_id														__attribute__	((packed)); 

	unsigned char		id_string_num_bytes							:6	__attribute__	((packed)); 
	unsigned char		id_string_type_code							:2	__attribute__	((packed)); 

	unsigned	char	id_string[16];																						
	} TYPE_01;

	/*
	 * Type 0x02, Digital/Discrete Reading, no thresholds
	 */
typedef struct	type_02
	{
	/*
	 * Sensor Record Header 
	 */
	unsigned short	record_id												__attribute__	((packed));

	unsigned	char	sdr_major_version	:4						__attribute__	((packed));
	unsigned	char	sdr_minor_version	:4						__attribute__	((packed));

	unsigned	char	record_type											__attribute__	((packed));	
	unsigned	char	record_length										__attribute__	((packed));
	/*
	 * Sensor Key
	 */
	unsigned	char	id_type						:1						__attribute__	((packed));
	unsigned	char	id								:7						__attribute__	((packed));

	unsigned	char	sensor_owner_lun	:2						__attribute__	((packed));
	unsigned	char	res1							:2						__attribute__	((packed));
	unsigned 	char	fru_owner_lun			:2						__attribute__	((packed));
	unsigned	char	res2							:2						__attribute__	((packed));

	unsigned	char	sensor_number										__attribute__	((packed));

	/*
	 * Body bytes
	 */
	unsigned	char	sensor_owner_confirm_device_id		__attribute__	((packed));
	unsigned	char	sensor_owner_confirm_fw_revision	__attribute__	((packed));

	unsigned	char	fru_inv_device_owner_id				:7	__attribute__	((packed));
	unsigned	char	fru_inv_device_owner_id_type	:1	__attribute__	((packed));

	unsigned	char	sensor_scanning_enabled				:1	__attribute__	((packed));
	unsigned	char	event_generation_enabled			:1	__attribute__	((packed));
	unsigned	char	res3													:2	__attribute__	((packed));
	unsigned	char	threshold_init_required				:1	__attribute__	((packed));
	unsigned	char	init_event_messages						:1	__attribute__	((packed));
	unsigned	char	init_scanning									:1	__attribute__	((packed));
	unsigned	char	sensor_init										:1	__attribute__	((packed));

	#define					PER_THRESHOLD_SHUTDOWN								0x00
	#define					ENTIRE_SENSOR_ONLY										0x01
	#define					GLOBAL_DISABLE_ONLY										0x02
	#define					NO_EVENTS_FROM_SENSOR									0x03
	unsigned	char	sens_capable_event_msg_shutdown	:2	__attribute__	((packed));
	#define					NO_EVENT_MSG_GENERATION								0x00
	#define					EVENT_MSG_GEN_TYPE_NOT_SPECIFIED			0x01
	#define					PER_TYPE_CODE_AND_EVENT_TRIGGER_MASK	0x02
	#define					RES1																	0x03
	unsigned	char	sens_capable_event_msg_gen			:2	__attribute__	((packed));
	unsigned	char	res4														:2	__attribute__	((packed));
	unsigned	char	sens_capable_auto_rearm					:1	__attribute__	((packed));
	unsigned	char	res5														:1	__attribute__	((packed));

	unsigned	char	sens_rec_sharing_share_cnt			:4	__attribute__	((packed));
	#define					SHARING_ID_MODIFIER_TYPE_NUMERIC			0x00
	#define					SHARING_ID_MODIFIER_TYPE_ALPHA				0x01
	unsigned	char	sens_rec_sharing_id_mtype				:2	__attribute__	((packed));
	unsigned	char	sens_rec_sharing_unknown				:2	__attribute__	((packed));

	unsigned	char	sens_rec_sharing_inst_mod_offset:7	__attribute__	((packed));
	#define					ENTITY_SHARING_ID_SAME_FOR_ALL_SHARED	0x00
	#define					ENTITY_SHARING_ID_INC_FOR_EACH_SHARED	0x01
	unsigned	char	sens_rec_sharing_ent_id_sharing	:1	__attribute__	((packed));
	
	unsigned	char	sensor_type													__attribute__	((packed));
	unsigned	char	event_reading_type_code							__attribute__	((packed));
	unsigned	short	event_trigger_mask									__attribute__	((packed));
	unsigned	short	event_reading_mask									__attribute__	((packed));
	
	unsigned	char	sensor_units_1_percentage				:1	__attribute__	((packed));
	#define					MODIFIER_NONE													0x00
	#define					BASIC_UNIT_DIV_MODIFIER_UNIT					0x01
	#define					BASIC_UNIT_MUL_MODIFIER_UNIT					0x02
	#define					RES2																	0x03
	unsigned	char	sensor_units_1_modifier_unit		:2	__attribute__	((packed));
	#define					RATE_NONE															0x00
	#define					RATE_US																0x01
	#define					RATE_MS																0x02
	#define					RATE_S																0x03
	#define					RATE_MINUTE														0x04
	#define					RATE_HOUR															0x05
	#define					RATE_DAY															0x06
	#define					RATE_RESERVED													0x07
	unsigned	char	sensor_units_1_rate_unit				:3	__attribute__	((packed));
	unsigned	char	sensor_units_1_res							:2	__attribute__	((packed));

	unsigned	char	sensor_units_2_base_unit						__attribute__	((packed));
	unsigned	char	sensor_units_3_modifier_unit				__attribute__	((packed));
	unsigned	char	oem																	__attribute__	((packed));
	unsigned	char	entity_id														__attribute__	((packed));

	unsigned char		id_string_num_bytes							:6	__attribute__	((packed));
	unsigned char		id_string_type_code							:2	__attribute__	((packed));

	unsigned	char	id_string[16];
	} TYPE_02;

	/*
	 * Type 0x10, IPMB Device Locator Record
	 */
typedef struct	type_10
	{
	/*
	 * Sensor Record Header 
	 */
	unsigned short	record_id												__attribute__	((packed));

	unsigned	char	sdr_major_version	:4						__attribute__	((packed));
	unsigned	char	sdr_minor_version	:4						__attribute__	((packed));

	unsigned	char	record_type											__attribute__	((packed));	
	unsigned	char	record_length										__attribute__	((packed));
	/*
	 * Sensor Key
	 */
	unsigned	char	reserved1												:1	__attribute__	((packed));
	unsigned	char	i2c_slave_address								:7	__attribute__	((packed));

	unsigned	char	reserved2												:4	__attribute__	((packed));
	unsigned	char	private_bus_id_or_lun						:2	__attribute__	((packed));
	#define					BUS_TYPE_IPMB					0x00
	#define					BUS_TYPE_PRIVATE_I2C	0x01
	unsigned	char	bus_type												:1	__attribute__	((packed));
	unsigned	char	reserved3												:1	__attribute__	((packed));

	/*
	 * Body bytes
	 */
	unsigned	char	address_span										:3	__attribute__	((packed));
	unsigned	char	reserved4												:5	__attribute__	((packed));

	unsigned	char	reserved5												:1	__attribute__	((packed));
	unsigned	char	dev_confirm_slave_address				:7	__attribute__	((packed));

	unsigned	char	dev_confirm_fw_revision							__attribute__	((packed));
	unsigned	char	device_type													__attribute__	((packed));
	unsigned	char	device_type_modifier								__attribute__	((packed));
	unsigned	char	device_location											__attribute__	((packed));
	unsigned	char	entity_id														__attribute__	((packed));
	unsigned	char	oem																	__attribute__	((packed));

	unsigned char		id_string_num_bytes							:6	__attribute__	((packed));
	unsigned char		id_string_type_code							:2	__attribute__	((packed));

	unsigned	char	id_string[16];
	} TYPE_10;

typedef struct type_c0
	{
	/*
	 * Sensor Record Header 
	 */
	unsigned short	record_id												__attribute__	((packed));

	unsigned	char	sdr_major_version	:4						__attribute__	((packed));
	unsigned	char	sdr_minor_version	:4						__attribute__	((packed));

	unsigned	char	record_type											__attribute__	((packed));	
	unsigned	char	record_length										__attribute__	((packed));
	unsigned	char	oem_data[64]										__attribute__	((packed));
	} TYPE_C0;

typedef struct sensor
	{
	SDR_HEADER					rec_header;
	union
		{
		TYPE_01						type_01_sensor;
		TYPE_02						type_02_sensor;
		TYPE_10						type_10_sensor;
		TYPE_C0						type_c0_sensor;
		} sensor_type;

	struct	sensor			*next;
	} SENSOR;
#define CMD_GET_SDR_REPOSITORY_INFO       0x20
#define CMD_GET_SDR_REPOSITORY_ALLOC_INFO 0x21
#define CMD_RESERVE_SDR_REPOSITORY        0x22
#define CMD_GET_SDR                       0x23
#define CMD_GET_SDR_REPOSITORY_TIME       0x28
#define CMD_GET_SENSOR_READING            0x2D

#endif
