#ifndef IPAC_H_INCLUDED
#define IPAC_H_INCLUDED
/*
 *
 * $Id: ipac.h,v 1.9 2000/08/07 10:24:22 kruemelmo Exp $
 *
 * ipac global header file for c porgrams
 * Copyright (C) 1997 - 2000 Moritz Both
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * The author can be reached via email: moritz@daneben.de, or by
 * snail mail: Moritz Both, Im Moore 26, 30167 Hannover,
 *             Germany. Phone: +49-511-1610129
 *
 */

/* =()<#define ACCTDIR "@<ACCTDIR>@">()= */
#define ACCTDIR "/var/log/ip-acct"
/* =()<#define RUNFILE "@<RUNFILE>@">()= */
#define RUNFILE "/var/run/ip-accounting-rules"
/* =()<#define IPACSET "@<INSTALLPATH>@/ipacset">()= */
#define IPACSET "/usr/local/bin/ipacset"
/* =()<#define DATDELIM "@<DATDELIM>@">()= */
#define DATDELIM "#-#-#-#-#"
/* =()<#define LOCKFILE "@<LOCKFILE>@">()= */
#define LOCKFILE "/var/lock/ipac.lck"
/* =()<#define CH_INNAME "@<CH_INNAME>@">()= */
#define CH_INNAME "ipac_in"
/* =()<#define CH_OUTNAME "@<CH_OUTNAME>@">()= */
#define CH_OUTNAME "ipac_out"
/* =()<#define CH_IONAME "@<CH_IONAME>@">()= */
#define CH_IONAME "ipac_bth"
/* =()<#define IPFWADM_PROC "@<IPFWADM_PROC>@">()= */
#define IPFWADM_PROC "/proc/net/ip_acct"
/* =()<#define IPCHAINS_PROC_C "@<IPCHAINS_PROC_C>@">()= */
#define IPCHAINS_PROC_C "/proc/net/ip_fwchains"
/* =()<#define MAX_RULE_NAME_LENGTH @<MAX_RULE_NAME_LENGTH>@>()= */
#define MAX_RULE_NAME_LENGTH 80
/* =()<#define MAX_PROCFILE_LINE_LENGTH @<MAX_PROCFILE_LINE_LENGTH>@>()= */
#define MAX_PROCFILE_LINE_LENGTH 256
/* =()<#define VERSION "@<VERSION>@">()= */
#define VERSION "1.10"

#include <stdio.h>

/* nonstandard type: 64 bit unsigned integer */
typedef unsigned long long int	UINT64;

/* lock.c */
int lock(const char *file);
int unlock(const char *file);

/* rule.c */
struct Srule_type {
	char		name[MAX_RULE_NAME_LENGTH+1];
	UINT64		bytes;
	UINT64		pkts;
	struct Srule_type *next;
};

typedef struct Srule_type rule_type;

rule_type *new_rule();
int rule_compare(const void *, const void *);

/* xmalloc.c */
void *xmalloc(size_t size);
char *xstrdup(const char *);

#endif
