-- Move current window in a frame to another frame in specified direction

function move_current(frame, dir)
    local curr=frame:current()
    local mgr=frame:manager()
    
    if not curr or not obj_is(mgr, "WIonWS") then 
        return 
    end
    
    local frame2=mgr:next_to(frame, dir)
    
    if frame2 then
        frame2:attach(curr, { switchto=true })
    end
end

ionframe_bindings{
    submap("Mod1+K", {
        kpress("Up", function(f) move_current(f, "above") end),
        kpress("Down", function(f) move_current(f, "below") end),
        kpress("Left", function(f) move_current(f, "left") end),
        kpress("Right", function(f) move_current(f, "right") end),
    }),
}
