/*  Inti-GL: Integrated Foundation Classes
 *  Copyright (C) 2003 The Inti Development Team.
 *
 *  drawable.cc - GdkGLDrawable C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "drawable.h"
#include "private/drawable_p.h"
#include "config.h"
#include "context.h"
#include <inti/glib/object.h>

using namespace Inti;

/*  Gdk::GL::Drawable
 */

Gdk::GL::Drawable::~Drawable()
{
}

GdkGLDrawableClass*
Gdk::GL::Drawable::gdk_gl_drawable_class() const
{
	return peek<GdkGLDrawableClass>(GDK_TYPE_GL_DRAWABLE);
}

Gdk::GL::Drawable::operator GdkGLDrawable* () const
{
	return this ? gdk_gl_drawable() : 0;
}

bool
Gdk::GL::Drawable::is_double_buffered() const
{
	return gdk_gl_drawable_is_double_buffered(gdk_gl_drawable());
}

Gdk::GL::Config*
Gdk::GL::Drawable::get_gl_config() const
{
	return G::Object::wrap<Config>(gdk_gl_drawable_get_gl_config(gdk_gl_drawable()));
}

void
Gdk::GL::Drawable::get_size(int *width, int *height) const
{
	gdk_gl_drawable_get_size(gdk_gl_drawable(), width, height);
}

Gdk::GL::Drawable*
Gdk::GL::Drawable::get_current()
{
	GdkGLDrawable *drawable = gdk_gl_drawable_get_current();
	Gdk::GL::Drawable *tmp_drawable = 0;
	if (drawable)
	{
		G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(drawable));
		tmp_drawable = dynamic_cast<Gdk::GL::Drawable*>(object);
	}
	return tmp_drawable;
}

bool
Gdk::GL::Drawable::make_current(Context& glcontext)
{
	return gdk_gl_drawable_make_current(gdk_gl_drawable(), glcontext.gdk_gl_context());
}

void
Gdk::GL::Drawable::swap_buffers()
{
	return gdk_gl_drawable_swap_buffers(gdk_gl_drawable());
}

void
Gdk::GL::Drawable::wait_gl()
{
	gdk_gl_drawable_wait_gl(gdk_gl_drawable());
}

void
Gdk::GL::Drawable::wait_gdk()
{
	gdk_gl_drawable_wait_gdk(gdk_gl_drawable());
}

bool
Gdk::GL::Drawable::gl_begin(Context& glcontext)
{
	return gdk_gl_drawable_gl_begin(gdk_gl_drawable(), glcontext.gdk_gl_context());
}

void
Gdk::GL::Drawable::gl_end()
{
	gdk_gl_drawable_gl_end(gdk_gl_drawable());
}

/*  Gdk::GL::DrawableClass
 */

void
Gdk::GL::DrawableClass::init(GdkGLDrawableClass *g_iface)
{
	g_iface->create_new_context = &create_new_context_proxy;
	g_iface->make_context_current = &make_context_current_proxy;
	g_iface->is_double_buffered = &is_double_buffered_proxy;
	g_iface->swap_buffers = &swap_buffers_proxy;
	g_iface->wait_gl = &wait_gl_proxy;
	g_iface->wait_gdk = &wait_gdk_proxy;
	g_iface->gl_begin = &gl_begin_proxy;
	g_iface->gl_end = &gl_end_proxy;
	g_iface->get_gl_config = &get_gl_config_proxy;
	g_iface->get_size = &get_size_proxy;
}

GdkGLContext*
Gdk::GL::DrawableClass::create_new_context_proxy(GdkGLDrawable *gldrawable, GdkGLContext *share_list, gboolean direct, int render_type)
{
	GdkGLContext *result = 0;
	G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(gldrawable));
	Gdk::GL::Drawable *drawable = dynamic_cast<Gdk::GL::Drawable*>(object);
	if (drawable)
		result = drawable->do_create_new_context(share_list, direct, render_type);
	else
	{
		void *tmp_iface = g_type_interface_peek_parent(GDK_GL_DRAWABLE_GET_CLASS(gldrawable));
		GdkGLDrawableClass *g_iface = static_cast<GdkGLDrawableClass*>(tmp_iface);
		if (g_iface->create_new_context)
			result = g_iface->create_new_context(gldrawable, share_list, direct, render_type);
	}
	return result;
}

gboolean
Gdk::GL::DrawableClass::make_context_current_proxy(GdkGLDrawable *gldrawable, GdkGLDrawable *read, GdkGLContext *glcontext)
{
	gboolean result = FALSE;
	G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(gldrawable));
	Gdk::GL::Drawable *drawable = dynamic_cast<Gdk::GL::Drawable*>(object);
	if (drawable)
		result = drawable->do_make_context_current(read, glcontext);
	else
	{
		void *tmp_iface = g_type_interface_peek_parent(GDK_GL_DRAWABLE_GET_CLASS(gldrawable));
		GdkGLDrawableClass *g_iface = static_cast<GdkGLDrawableClass*>(tmp_iface);
		if (g_iface->make_context_current)
			result = g_iface->make_context_current(gldrawable, read, glcontext);
	}
	return result;
}

gboolean
Gdk::GL::DrawableClass::is_double_buffered_proxy(GdkGLDrawable *gldrawable)
{
	gboolean result = FALSE;
	G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(gldrawable));
	Gdk::GL::Drawable *drawable = dynamic_cast<Gdk::GL::Drawable*>(object);
	if (drawable)
		result = drawable->do_is_double_buffered();
	else
	{
		void *tmp_iface = g_type_interface_peek_parent(GDK_GL_DRAWABLE_GET_CLASS(gldrawable));
		GdkGLDrawableClass *g_iface = static_cast<GdkGLDrawableClass*>(tmp_iface);
		if (g_iface->is_double_buffered)
			result = g_iface->is_double_buffered(gldrawable);
	}
	return result;
}

void
Gdk::GL::DrawableClass::swap_buffers_proxy(GdkGLDrawable *gldrawable)
{
	G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(gldrawable));
	Gdk::GL::Drawable *drawable = dynamic_cast<Gdk::GL::Drawable*>(object);
	if (drawable)
		drawable->do_swap_buffers();
	else
	{
		void *tmp_iface = g_type_interface_peek_parent(GDK_GL_DRAWABLE_GET_CLASS(gldrawable));
		GdkGLDrawableClass *g_iface = static_cast<GdkGLDrawableClass*>(tmp_iface);
		if (g_iface->swap_buffers)
			g_iface->swap_buffers(gldrawable);
	}
}

void
Gdk::GL::DrawableClass::wait_gl_proxy(GdkGLDrawable *gldrawable)
{
	G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(gldrawable));
	Gdk::GL::Drawable *drawable = dynamic_cast<Gdk::GL::Drawable*>(object);
	if (drawable)
		drawable->do_wait_gl();
	else
	{
		void *tmp_iface = g_type_interface_peek_parent(GDK_GL_DRAWABLE_GET_CLASS(gldrawable));
		GdkGLDrawableClass *g_iface = static_cast<GdkGLDrawableClass*>(tmp_iface);
		if (g_iface->wait_gl)
			g_iface->wait_gl(gldrawable);
	}
}

void
Gdk::GL::DrawableClass::wait_gdk_proxy(GdkGLDrawable *gldrawable)
{
	G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(gldrawable));
	Gdk::GL::Drawable *drawable = dynamic_cast<Gdk::GL::Drawable*>(object);
	if (drawable)
		drawable->do_wait_gdk();
	else
	{
		void *tmp_iface = g_type_interface_peek_parent(GDK_GL_DRAWABLE_GET_CLASS(gldrawable));
		GdkGLDrawableClass *g_iface = static_cast<GdkGLDrawableClass*>(tmp_iface);
		if (g_iface->wait_gdk)
			g_iface->wait_gdk(gldrawable);
	}
}

gboolean
Gdk::GL::DrawableClass::gl_begin_proxy(GdkGLDrawable *gldrawable, GdkGLDrawable *read, GdkGLContext *glcontext)
{
	gboolean result = FALSE;
	G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(gldrawable));
	Gdk::GL::Drawable *drawable = dynamic_cast<Gdk::GL::Drawable*>(object);
	if (drawable)
		result = drawable->do_gl_begin(read, glcontext);
	else
	{
		void *tmp_iface = g_type_interface_peek_parent(GDK_GL_DRAWABLE_GET_CLASS(gldrawable));
		GdkGLDrawableClass *g_iface = static_cast<GdkGLDrawableClass*>(tmp_iface);
		if (g_iface->gl_begin)
			result = g_iface->gl_begin(gldrawable, read, glcontext);
	}
	return result;
}

void
Gdk::GL::DrawableClass::gl_end_proxy(GdkGLDrawable *gldrawable)
{
	G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(gldrawable));
	Gdk::GL::Drawable *drawable = dynamic_cast<Gdk::GL::Drawable*>(object);
	if (drawable)
		drawable->do_gl_end();
	else
	{
		void *tmp_iface = g_type_interface_peek_parent(GDK_GL_DRAWABLE_GET_CLASS(gldrawable));
		GdkGLDrawableClass *g_iface = static_cast<GdkGLDrawableClass*>(tmp_iface);
		if (g_iface->gl_end)
			g_iface->gl_end(gldrawable);
	}
}

GdkGLConfig*
Gdk::GL::DrawableClass::get_gl_config_proxy(GdkGLDrawable *gldrawable)
{
	GdkGLConfig *result = 0;
	G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(gldrawable));
	Gdk::GL::Drawable *drawable = dynamic_cast<Gdk::GL::Drawable*>(object);
	if (drawable)
		result = drawable->do_get_gl_config();
	else
	{
		void *tmp_iface = g_type_interface_peek_parent(GDK_GL_DRAWABLE_GET_CLASS(gldrawable));
		GdkGLDrawableClass *g_iface = static_cast<GdkGLDrawableClass*>(tmp_iface);
		if (g_iface->get_gl_config)
			result = g_iface->get_gl_config(gldrawable);
	}
	return result;
}

void
Gdk::GL::DrawableClass::get_size_proxy(GdkGLDrawable *gldrawable, gint *width, gint *height)
{
	G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(gldrawable));
	Gdk::GL::Drawable *drawable = dynamic_cast<Gdk::GL::Drawable*>(object);
	if (drawable)
		drawable->do_get_size(width, height);
	else
	{
		void *tmp_iface = g_type_interface_peek_parent(GDK_GL_DRAWABLE_GET_CLASS(gldrawable));
		GdkGLDrawableClass *g_iface = static_cast<GdkGLDrawableClass*>(tmp_iface);
		if (g_iface->get_size)
			g_iface->get_size(gldrawable, width, height);
	}
}

/*  Overridable GdkGLDrawable methods
 */

GdkGLContext*
Gdk::GL::Drawable::do_create_new_context(GdkGLContext *share_list, bool direct, int render_type)
{
	GdkGLContext *result = 0;
	GdkGLDrawableClass *g_iface = peek_parent<GdkGLDrawableClass>(gdk_gl_drawable_class());
	if (g_iface->create_new_context)
		result = g_iface->create_new_context(gdk_gl_drawable(), share_list, direct, render_type);
	return result;
}

bool
Gdk::GL::Drawable::do_make_context_current(GdkGLDrawable *read, GdkGLContext *glcontext)
{
	bool result = false;
	GdkGLDrawableClass *g_iface = peek_parent<GdkGLDrawableClass>(gdk_gl_drawable_class());
	if (g_iface->make_context_current)
		result = g_iface->make_context_current(gdk_gl_drawable(), read, glcontext);
	return result;
}

bool
Gdk::GL::Drawable::do_is_double_buffered()
{
	bool result = false;
	GdkGLDrawableClass *g_iface = peek_parent<GdkGLDrawableClass>(gdk_gl_drawable_class());
	if (g_iface->is_double_buffered)
		result = g_iface->is_double_buffered(gdk_gl_drawable());
	return result;
}

void
Gdk::GL::Drawable::do_swap_buffers()
{
	GdkGLDrawableClass *g_iface = peek_parent<GdkGLDrawableClass>(gdk_gl_drawable_class());
	if (g_iface->swap_buffers)
		g_iface->swap_buffers(gdk_gl_drawable());
}

void
Gdk::GL::Drawable::do_wait_gl()
{
	GdkGLDrawableClass *g_iface = peek_parent<GdkGLDrawableClass>(gdk_gl_drawable_class());
	if (g_iface->wait_gl)
		g_iface->wait_gl(gdk_gl_drawable());
}

void
Gdk::GL::Drawable::do_wait_gdk()
{
	GdkGLDrawableClass *g_iface = peek_parent<GdkGLDrawableClass>(gdk_gl_drawable_class());
	if (g_iface->wait_gdk)
		g_iface->wait_gdk(gdk_gl_drawable());
}

bool
Gdk::GL::Drawable::do_gl_begin(GdkGLDrawable *read, GdkGLContext *glcontext)
{
	bool result = false;
	GdkGLDrawableClass *g_iface = peek_parent<GdkGLDrawableClass>(gdk_gl_drawable_class());
	if (g_iface->gl_begin)
		result = g_iface->gl_begin(gdk_gl_drawable(), read, glcontext);
	return result;
}

void
Gdk::GL::Drawable::do_gl_end()
{
	GdkGLDrawableClass *g_iface = peek_parent<GdkGLDrawableClass>(gdk_gl_drawable_class());
	if (g_iface->gl_end)
		g_iface->gl_end(gdk_gl_drawable());
}


GdkGLConfig*
Gdk::GL::Drawable::do_get_gl_config()
{
	GdkGLConfig *result = 0;
	GdkGLDrawableClass *g_iface = peek_parent<GdkGLDrawableClass>(gdk_gl_drawable_class());
	if (g_iface->get_gl_config)
		result = g_iface->get_gl_config(gdk_gl_drawable());
	return result;
}

void
Gdk::GL::Drawable::do_get_size(int *width, int *height)
{
	GdkGLDrawableClass *g_iface = peek_parent<GdkGLDrawableClass>(gdk_gl_drawable_class());
	if (g_iface->get_size)
		g_iface->get_size(gdk_gl_drawable(), width, height);
}

