/*
integrit - file integrity verification system
Copyright (C) 2000, 2001 Ed L. Cashin

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
/* header file for sha1 routines from gnupg, based directly on sha1.c */

#ifndef	ELC_SHA1_H
#define	ELC_SHA1_H

/* size of the SHA1 checksum is in sha1.c's sha1_get_info routine */
#define	SHA1_DIGEST_LENGTH 20

typedef struct {
    uint32_t  h0,h1,h2,h3,h4;
    uint32_t  nblocks;
    uint8_t buf[64];
    int  count;
} SHA1_CONTEXT;

void sha1_init( SHA1_CONTEXT *hd );

/* (sha1_write is the equivalent of what others call sha1_update) */
void sha1_write( SHA1_CONTEXT *hd, uint8_t *inbuf, size_t inlen);

void sha1_final(SHA1_CONTEXT *hd);

uint8_t *sha1_read( SHA1_CONTEXT *hd );

#endif
