/***************************************************************************
                          objectdb.cpp  -  description                              
                             -------------------                                         
    begin                : Tue Aug 3 1999                                           
    copyright            : (C) 1999 by Jon Anderson                         
    email                : janderson@onelink.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <objectdb.h>
#include <Entities/object.h>
#include <Entities/vertex.h>
#include <Entities/mesh.h>
#include <Entities/edge.h>
#include <Entities/face.h>
#include <Entities/bone.h>
#include <Entities/line.h>
#include <Entities/poly.h>
#include <Entities/nurbscurve.h>
#include <Entities/nurbssurface.h>

#include <time.h>

ObjectDB *ObjectDB::objectdb=0;

ObjectDB::ObjectDB():QObject(),
db(),
selected(),
dblist()
{
	
	cerr<<"Memory sizes:"<<endl;
	cerr<<" SbObj :\t"<<sizeof(SubObject)<<endl;
	cerr<<" Vrtx  :\t"<<sizeof(Vertex)<<endl;
	cerr<<" Edge  :\t"<<sizeof(Edge)<<endl;			
	cerr<<" Face  :\t"<<sizeof(Face)<<endl;
	cerr<<" Mesh  :\t"<<sizeof(Mesh)<<endl;
	cerr<<" Obj   :\t"<<sizeof(Object)<<endl;
	cerr<<" Ent   :\t"<<sizeof(Entity)<<endl;
	cerr<<" Trsfbl:\t"<<sizeof(Transformable)<<endl;
	cerr<<" IDed  :\t"<<sizeof(IDed)<<endl;
	cerr<<" Typed :\t"<<sizeof(Typed)<<endl;
	cerr<<" Rndrbl:\t"<<sizeof(Renderable)<<endl;
	cerr<<" Slctbl:\t"<<sizeof(Selectable)<<endl;
	cerr<<" Antbl :\t"<<sizeof(Animatable)<<endl;
	cerr<<" Ctrlr :\t"<<sizeof(Controller)<<endl;
	cerr<<" BBox  :\t"<<sizeof(BoundingBox)<<endl;
	cerr<<" Vctor :\t"<<sizeof(Vector4)<<endl;
	cerr<<" Mtrix :\t"<<sizeof(Matrix44)<<endl;
	cerr<<" Quat  :\t"<<sizeof(Quat)<<endl;
	
	cerr<<" STL vector<int>:"<<sizeof(vector<int>)<<endl;
	cerr<<" STL string:"<<sizeof(string)<<endl;

	cerr << "Dynamic UIDS" << endl;
	cerr<<" SubObject:"<<SubObject::TYPE<<endl;
	cerr<<" Vertex:"<<Vertex::TYPE<<endl;
	cerr<<" Edge:"<<Edge::TYPE<<endl;			
	cerr<<" Face:"<<Face::TYPE<<endl;
	cerr<<" Mesh:"<<Mesh::TYPE<<endl;
	cerr<<" Object:"<<Object::TYPE<<endl;
	cerr<<" Entity:"<<Entity::TYPE<<endl;
	cerr<<" Bone:"<<Bone::TYPE<<endl;
	cerr<<" NURBS Curve:"<<NurbsCurve::TYPE<<endl;
	cerr<<" NURBS Surface:"<<NurbsSurface::TYPE<<endl;
	cerr<<" Line:"<<Line::TYPE<<endl;	
	cerr<<" Poly:"<<Poly::TYPE<<endl;	
	

/*
	cerr << "Constructing 1,000,000 vector4's and adding...";
	Vector4 t;
	clock_t begin = clock();
	for(int i=0; i<1000000; i++){
		Vector4 p(i, 1000, 1000, 1000);
		t += p;
	}	
	clock_t end = clock();
	cerr << (float)(end-begin) << " seconds."<<endl;
	
	cerr << "Constructing 10,000 vertices";

  begin = clock();
	Mesh *m = new Mesh();
	for(int i=0; i<10000; i++) {
		new Vertex(i, i, i, m);
	}
	end = clock();
	cerr << (float)(end-begin) << " seconds."<<endl;
	
	cerr << "Constructing 10,000 faces";
  begin = clock();
	for(int i=0; i<10000; i++) {
		new Face(i, i, i, m);
	}
	end = clock();
	cerr << (float)(end-begin) << " seconds."<<endl;
	*/
	
	selected.reserve(512);

	size = 0;
}
ObjectDB::~ObjectDB()
{
}

void ObjectDB::add(Selectable *e)
{
		
	int type = e->getBaseType();
	
cerr<<"Adding of type : "<<type<<endl;
	
	vector<Selectable *> *v;
	
	SelectableMap::iterator it = db.find(type);
	if(it == db.end()){
		v = new vector<Selectable *>();
		v->reserve(25);
		db.insert(SelectablePair(type, v));
	} else{
		v = it->second;
	}
		
	//check for redundancy.
	
	v->push_back(e);
	
}
/**Returns an Selectable.  If type is -1, it will search all the entities lists.
  */
Selectable *ObjectDB::get(int id, int type=-1)
{
	vector<Selectable *> *v;
	if(type == -1){
		SelectableMap::iterator it = db.begin();
		while(it != db.end()){
			v = it->second;
			if(v !=0){
				for(int j=0; j<(int)v->size(); j++){
		 			if((*v)[j]->getID() == id){
	 			 		return (*v)[j];
	 		 		}
	 			}
	 		++it;
		 	}//while
	 	}
	 	return 0;
	}
		

	SelectableMap::iterator it = db.find(type);
	
	if(it == db.end())
		return 0;
			
	v = it->second;
	
	
	for(int i=0; i<(int)v->size(); i++){
	 	if((*v)[i]->getID() == id)
	 		return (*v)[i];
	}
	return 0;	
}

void ObjectDB::remove(Selectable *e)
{
	int type = e->getBaseType();
	
	SelectableMap::iterator it = db.find(type);
	if(it == db.end())
		return;
	
	vector<Selectable *> *v;
	
	v = it->second;
	vector<Selectable *>::iterator vit;
	vit = find( v->begin(), v->end(), e );
	
	if( vit != v->end() )
		v->erase( vit );
	else {
		cerr << "Can't find object to delete!"<<endl;
	}
	
			

}
/**Draws the objects in the DB.  It checks each vector of entities in the db,
  *and checks if they are drawable.  If they are, it draws them. */
void ObjectDB::draw()
{
  vector<Selectable *> *v;
	SelectableMap::iterator it = db.begin();
	
	while(it != db.end()){
	
	 v = it->second;
	
		for(int j=0; j<(int)v->size(); j++ ) {	
	 		Entity * e = (Entity*)  (*v)[j] ;
//	 		cerr<< "Rendering type:"<<e->getType()<<endl;
	 		if( e != 0 ) {
            if(e->isVisible())
				   e -> render();
			}
		}
		
	 ++it;
	
	}//while
}
void ObjectDB::setNoneSelected()
{
	for(int i=0; i<(int)selected.size(); i++)
		selected[i]->setSelected(false);
		
	selected.erase(selected.begin(), selected.end());

}
Selectable * ObjectDB::toggleSelected(Selectable *e)
{
	
	if(find(selected.begin(), selected.end(), e) == selected.end()){
		setSelected(e);
		return e;	
	}
	
	selected.erase(find(selected.begin(), selected.end(), e));
	e->setSelected(false);

	return e;
}

Selectable * ObjectDB::setSelected(Selectable *e)
{
 e->setSelected(true);
 selected.push_back(e);
 return e;
}	

Selectable *ObjectDB::removeSelected(Selectable *e)
{
	e->setSelected(false);
	
	selected.erase(find(selected.begin(), selected.end(), e));
	
	return e;
}
	
vector<Selectable *> * ObjectDB::getSelected()
{
	return &selected;
}

Selectable *ObjectDB::getFirst(int type)
{
	SelectableMap::iterator it = db.find(type);
	if(it != db.end())
		return (*(it->second))[0];
	else
		return 0;
	
}

vector<Selectable *> *ObjectDB::getSelectables(int type)
{
	SelectableMap::iterator it = db.find(type);
	if(it!= db.end())
		return it->second;
	else
		return 0;
}

ObjectDB *ObjectDB::getInstance()
{
	if(objectdb==0)
		objectdb = new ObjectDB();
	
	
		
  return objectdb;
}

vector<Selectable*> * ObjectDB::getList()
{
	dblist.clear();
	
		//take care of affecting here...
	SelectableMap::iterator it = db.begin();
	while (it != db.end()){
		vector<Selectable *> *elist = it->second;
		for(int i=0; i<(int)elist->size(); i++){
			Selectable * e = (*elist)[i];
			dblist.push_back(e);
		}
		++it;
	}
	return &dblist;

}























