/***************************************************************************
                          basecontroller.h  -  description                              
                             -------------------                                         
    begin                : Thu Oct 7 1999                                           
    copyright            : (C) 1999 by Jon Anderson                         
    email                : janderson@onelink.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef BASECONTROLLER_H
#define BASECONTROLLER_H

#include <list>

/**This is a singleton class that keeps track of
all timing for the application.  Anything dependant
on the current internal time of the app (like animation)
should connect to this classes changeTime(int) or'
incrementTime(int) signals.    Instances of the BaseController can be obtained by calling
<code>getInstance()</code>
  *@author Jon Anderson
  */
class Controller;

class BaseController {

public: 
	~BaseController();
	/**Returns the current applicaiton time */
	int getTime() {return time;};
	/**Sets the application time to the specified time */
	void setTime(int i);
	/**Increments the time. */
	void incrementTime();
	/**Saves the specified time as a keyframe */
	void save(int);
	/**loads the specified time as a keyframe */
	void load(int);
	static BaseController * getInstance();
	
	void addController(Controller *c);
	void removeController(Controller *c);
	
	
private:
	BaseController();
	
	static BaseController *bc;
	int time;
	list<Controller *> controllers;
	
};

#endif




