/***************************************************************************
                         glmdiview.cpp  -  description
                            -------------------
   begin                : Fri Jan 14 2000
   copyright            : (C) 2000 by Jon Anderson
   email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "glmdiview.h"
#include "glview.h"


GLMdiView::GLMdiView( char *caption, QWidget *_p )
      : QextMdiChildView( caption, _p )
{
   view = 0;

   setFocusPolicy( QWidget::ClickFocus );
   layout = new QGridLayout( this );

}

GLMdiView::~GLMdiView()
{}

void GLMdiView::resizeEvent( QResizeEvent *e )
{
   QextMdiChildView::resizeEvent( e );

   if ( view != 0 )
   {
      view -> updateGL();
   }


}

void GLMdiView::updateGL()
{
   if ( view == 0 )
   {
      return ;
   }

   view->updateGL();
}

/**These send all key events to the view, so the user doesn't have to
  *click the view itself to get keyboard focus.
  */
void GLMdiView::keyPressEvent( QKeyEvent *event )
{
   if ( view == 0 )
   {
      return ;
   }

   if ( !view->hasFocus() )
      view->keyPressEvent( event );
}

void GLMdiView::keyReleaseEvent( QKeyEvent *event )
{
   if ( view == 0 )
   {
      return ;
   }


   if ( !view->hasFocus() )
      view->keyReleaseEvent( event );
}


void GLMdiView::setView( GLView *v )
{
   view = v;
   //installEventFilterForAllChildren();
   layout -> addWidget( v, 0, 0 );
}
