/***************************************************************************
                          sphericalwrap.cpp  -  description
                             -------------------
    begin                : Sat Oct 14 2000
    copyright            : (C) 2000 by Jon Anderson
    email                : janderson@onelink.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "sphericalwrap.h"
#include <Entities/face.h>
#include <Entities/vertex.h>


SphericalWrap::SphericalWrap() :UVWrap()
{
}
SphericalWrap::~SphericalWrap(){
}

Entity * SphericalWrap::clone()
{
	UVWrap *v = new SphericalWrap();
	*v = *this;
	return v;
}	
int SphericalWrap::draw(int d_options = 0)
{
		
	glPushMatrix();
		
	Matrix44 m;
	getCompleteMatrix(&m);
	glMultMatrixf((GLfloat *)(m.m));
	
  glLineWidth( 2 );
	
	//draw UV here.
	glColor4f(0.5, 0, 0, 1);
	glutWireSphere(0.5 * m_scale.x, 10, 10);
	
	glBegin(GL_LINES);
		glColor4f(.5, 0, 0, 1);
		glVertex3f(0, 0, 0              );
		glVertex3f(0, 1.5 * m_scale.x, 0);
		glColor4f(0, .5, 0, 1);
		glVertex3f(0, 0, 0              );
		glVertex3f(1.5 * m_scale.x, 0, 0);
	glEnd();

	glLineWidth( 1 );
	glPopMatrix();

	return 0;
}

void SphericalWrap::createMapping(vector<SubObject  *> *faces)
{
	Face *f;
	int num_verts;
	Matrix44 m;
	Vector4 uv;
	
	getCompleteMatrix(&m);
	m.Invert();
	
	for(int i=0; i<(int)faces->size(); i++){
		f = (Face *) (*faces)[i];
		num_verts = f->getNumVerts();
		for(int j=0; j<num_verts; j++){
			//transform the point into the planes space.
			Vector4 pt;
			f->getVertPtr(j) -> getTransformedPosition( &pt);
			pt = m * pt;
		
			uv.x = 1 - ( atan2(pt.x, -pt.z) / (2 * M_PI) + 0.5 );	
			pt.normalize();
			uv.y = asin(pt.y) / M_PI + 0.5;
			
			f -> setUVCoord(j, uv);
		}
		f -> normalizeUVs(true, true);
				
	}

}
