/***************************************************************************
                         material.cpp  -  description
                            -------------------                          
   begin                : Wed Mar 10 1999                          
   copyright            : (C) 1999 by Jon Anderson                         
   email                : ande1514@tc.umn.edu                      
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "material.h"

Material::Material( float _r = .5, float _g = .5, float _b = .5, int _ID = -1 )
{

   r = _r;
   g = _g;
   b = _b;
   a = 1;
   ID = _ID;

   pixmap = new QPixmap( 64, 64 );
   pixmap->fill( *( new QColor( ( int ) r * 255, ( int ) g * 255, ( int ) b * 255 ) ) );
}

Material::~Material()
{
   delete pixmap;
}

void Material::setRGB( float _r, float _g, float _b )
{
   r = _r;
   g = _g;
   b = _b;
   pixmap->fill( *( new QColor( r * 255, g * 255, b * 255 ) ) );
}

























