/***************************************************************************
                         controller.h  -  description                              
                            -------------------                                         
   begin                : Sat Aug 14 1999                                           
   copyright            : (C) 1999 by Jon Anderson                         
   email                : janderson@onelink.com                                     
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef CONTROLLER_H
#define CONTROLLER_H

//QT includes
//#include "qsortedlist.h"
#include <Math/matrix44.h>
#include <Math/vector3.h>
#include <Math/vector4.h>

#include <vector>
#include <list>
#include <string>


//local includes

class Animatable;

class Keyframe;

/**A controller controls the state of an entity.  A state consists
 * a collection of attribute for for 1-n keyframes.  A controller allows 
 * animation of objects based on t(time).
 *
 * The main job of the controller is to remember keyframe/time relationships.
 * If the current time is the time of a keyframe, it will use that keyframe
 * for it's state information.  If the time is inbetween keyframes, it will
 * interpolate states based on the between keyframes.
 *
 * Anything that is stored as a vector4 can be animated via a controller.
 * As said earlier, inbetween times are interpolated.  However, you don't 
 * always want to do this, for things like texture maps. If this is the case
 * you should set the interpolate flag of the vector you pass in as an 
 * attribute to false.  When the flag is false, it will use the state of the
 * previous keyframe as a value.
 * 
 *@author Jon Anderson
 */

class Controller
{

   public:
      Controller();

      virtual ~Controller();

      void setAnimatable( Animatable *a ) {ent = a;};

      Vector4 getAttrib( int );
      void setAttrib( int, const Vector4 & );

      int getID() { return ID;};

      void setDirty( bool flag ) {dirty = flag;};

      bool isDirty() { return dirty;};

      void toggleDirty() {dirty = !dirty;};

      void setRepeat( bool flag ) {wraparound = flag;};

      bool isRepeat() { return wraparound;};

      Controller & operator=( Controller &rhs );

      void saveTime( int time );
      void loadTime( int time );
      void incrementTime();


   private:
      Animatable *ent;
      vector<Keyframe> frames;
      Keyframe *prev;
      Keyframe *next;
      int time;
      int max_time;
      bool dirty;
      int ID;
      int type;

      bool wraparound;

};

#endif

















