/***************************************************************************
                          transactioncommand.h  -  description
                             -------------------                                         
    begin                : Sun Dec 5 1999                                           
    copyright            : (C) 1999 by Jon Anderson                         
    email                : janderson@onelink.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef TRANSCOMMAND_H
#define TRANSCOMMAND_H

#include "command.h"
#include <list>
#include <algorithm>

/** A transaction command contains a list of commands.
  * All commands are then executed/undone in a single transaction.
  *@author Jon Anderson
  */

class TransactionCommand : public Command  {
public: 
	TransactionCommand();
	virtual ~TransactionCommand();
	
	/**Change the default list */
	void addCommand(Command *);
	void removeCommand(Command *);
	bool execute();
	bool undo();
	int count();

protected: // Protected attributes
  /** A pointer to the global list of available
		* entities.  This list can be used for add and
		* remove operations. */
//  ObjectDB *db;
  list<Command *> clist;
  int size;
};

#endif
