1;;; initz-globals.el --- Global variables and constants.

;; Copyright (C) 2002 OHASHI Akira <bg66@koka-in.org>

;; Author: OHASHI Akira <bg66@koka-in.org>
;; Keywords: startup, init

;; This file is part of Initz.

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.


;;; Commentary:
;;

;;; Code:

(defconst initz-null-string "")

(defconst initz-separator-string "-")

(defconst initz-module-regexp "[-.a-zA-Z0-9]+")

(defconst initz-flavor
  (if (featurep 'xemacs)
      (concat "xemacs" (number-to-string emacs-major-version))
    (if (featurep 'meadow)
        (concat "meadow"
                (let ((mver (Meadow-version)))
		  (if (string-match "Meadow-\\([0-9]+\\.[0-9]+\\)"
                                    mver)
                      (match-string 1 mver))))
      (concat "emacs" (number-to-string emacs-major-version)))))

(defconst initz-load-module-ask-message-format
  "Load init file for %s? ")

(defconst initz-load-module-message-format
  "Loading init file for %s...")

(defconst initz-unload-module-message-format
  "Unloading init file for %s...")

(defvar initz-error-compile-files nil)

(defvar initz-error-load-files nil)

(provide 'initz-globals)

;;; initz-globals.el ends here
