<?php

$block_name = _("Menu Folder List");
$block_type = 'tree';

/**
 * $Horde: imp/lib/Block/tree_folders.php,v 1.28.2.1 2005/01/13 21:15:06 chuck Exp $
 *
 * @package Horde_Block
 */
class Horde_Block_imp_tree_folders extends Horde_Block {

    var $_app = 'imp';

    function _buildTree(&$tree, $indent = 0, $parent = null)
    {
        global $registry, $prefs;

        $GLOBALS['authentication'] = 'none';
        @define('IMP_BASE', dirname(__FILE__) . '/../..');
        require_once IMP_BASE . '/lib/base.php';
        require_once IMP_BASE . '/lib/IMAP/Tree.php';
        require_once 'Horde/Identity.php';

        /* Abort immediately if we're not currently logged in to
         * IMP or using a POP3 server. */
        if (IMP::checkAuthentication(OP_HALFOPEN, true) !== true ||
            $_SESSION['imp']['base_protocol'] == 'pop3') {
            return;
        }

        /* Initialize the user's identities. */
        $identity = &Identity::singleton(array('imp', 'imp'));

        /* Get special folders. */
        $trash = IMP::addPreambleString($prefs->getValue('trash_folder'));
        $draft = IMP::addPreambleString($prefs->getValue('drafts_folder'));
        $sent = $identity->getAll('sent_mail_folder');
        $sent = array_filter($sent, create_function('$mbox', 'return !empty($mbox);'));
        $sent = array_map(array('IMP', 'addPreambleString'), $sent);

        $tree->addnode($parent . 'compose', $parent, _("Compose"),
                       $indent, false,
                       array('icon' => 'compose.png',
                             'icondir' => $registry->getImageDir(),
                             'url' => IMP::composeLink(),
                             'target' => $prefs->getValue('compose_popup') ? 'horde_menu' : 'horde_main'));

        $name_url = Util::addParameter(Horde::applicationUrl('mailbox.php'), 'no_newmail_popup', 1);

        /* Initialize the IMP_Tree object. */
        $imptree = &IMP_Tree::singleton();

        /* Start iterating through the list of mailboxes, displaying them. */
        $unseen = 0;
        $inbox = null;
        $mailbox = $imptree->reset();
        if ($mailbox) {
            do {
                $node_params = array();

                if (!$imptree->isContainer($mailbox)) {
                    /* We are dealing with mailboxes here. Determine if we
                     * need to poll this mailbox for new messages. */
                    if ($imptree->isPolled($mailbox)) {
                        /* If we need message information for this folder,
                         * update it now. */
                        $msgs_info = $imptree->getElementInfo($mailbox['value']);
                        if (!empty($msgs_info)) {
                            /* Highlight mailboxes with unread messages in
                             * bold. */
                            if (!empty($msgs_info['unseen'])) {
                                $unseen += $msgs_info['unseen'];
                                $mailbox['label'] = '<b>' . $mailbox['label'] . '</b> (' . $msgs_info['unseen'] . ')';
                            }
                        }
                    }

                    /* If this is the INBOX, save it to later rewrite our parent
                     * node to include new mail notification. */
                    if (strcasecmp($mailbox['value'], 'INBOX') == 0) {
                        $inbox = $mailbox;
                    }

                    switch ($mailbox['value']) {
                    case 'INBOX':
                        $dir2 = 'inbox.png';
                        break;

                    case $trash:
                        $dir2 = 'trash.png';
                        break;

                    case $draft:
                        $dir2 = 'drafts.png';
                        break;

                    default:
                        if (in_array($mailbox['value'], $sent)) {
                            $dir2 = 'sent.png';
                        } else {
                            if (isset($mbox_icons[$mailbox['value']])) {
                                $dir2 = $mbox_icons[$mailbox['value']];
                            } else {
                                $dir2 = 'folder.png';
                                $node_params['iconopen'] = 'folders/folder_open.png';
                            }
                        }
                        break;
                    }
                } else {
                    /* We are dealing with folders here. */
                    $dir2 = 'folder.png';
                    $node_params['iconopen'] = 'folders/folder_open.png';
                }

                /* The indent level of the current folder. */
                $indent_level = $mailbox['level'];

                /* If we have a folder prefix, shift each folder in the
                 * hierarchy up one level before showing it to the
                 * user. */
                if (!empty($prefix) &&
                    ($mailbox['value'] != 'INBOX') &&
                    String::substr($mailbox['value'], 0, String::length($notrail_prefix)) == $notrail_prefix) {
                    $indent_level--;
                }

                if ($indent_level >= 0) {
                    $node_params += array('icon' => 'folders/' . $dir2,
                                          'icondir' => $registry->getImageDir(),
                                          'url' => ($imptree->isContainer($mailbox)) ? null : Util::addParameter($name_url, 'mailbox', $mailbox['value']),
                                         );
                    $tree->addNode($parent . $mailbox['value'],
                                   $parent . $mailbox['parent'],
                                   $mailbox['label'], $indent + $indent_level, false, $node_params);
                }
            } while (($mailbox = $imptree->next(IMAPTREE_NEXT_SHOWCLOSED)));
        }

        /* We want to rewrite the parent node of the INBOX to include new mail
         * notification. */
        if ($inbox) {
            if ($registry->get('url', $parent)) {
                $url = $registry->get('url', $parent);
            } elseif ($registry->get('status', $parent) == 'heading' ||
                      !$registry->get('webroot')) {
                $url = null;
            } else {
                $url = Horde::url($registry->getInitialPage($parent));
            }

            $node_params = array('url' => $url,
                                 'icon' => $registry->get('icon', $parent),
                                 'icondir' => '');
            if ($unseen) {
                $node_params['icon'] = 'newmail.png';
                $node_params['icondir'] = $registry->getImageDir();
                $tree->addNode($parent, $registry->get('menu_parent', $parent),
                               sprintf('<b>%s</b> (%s)', $registry->get('name', $parent), $unseen),
                               $indent - 1, false, $node_params);
            } else {
                $tree->addNode($parent, $registry->get('menu_parent', $parent),
                               $registry->get('name', $parent), $indent - 1, false, $node_params);
            }
        }

        /* Add link to the search page. */
        $tree->addnode($parent . 'search', $parent, _("Search Mail"),
                       $indent, false,
                       array('icon' => 'search.png',
                             'icondir' => $registry->getImageDir('horde'),
                             'url' => Horde::applicationUrl('search.php')));
    }

}
