/* Stamp
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <getopt.h>
#include <string.h>
#include <jpeglib.h>
#include "../lib/common.h"
#include "../lib/rcfile.h"
#include "stamp.h"


int main(int argc, char **argv) { 
  struct ArgStruct *Args ;
  int r;

  extern char *stamperror[];

  Args = malloc(sizeof(struct ArgStruct)) ;
  Set_Default_Args(Args) ;
  Parse_Stamp_Args(argc, argv, Args) ;
  RC_load(Args) ;
  Check_Args(Args) ;
  r = stamp_main(Args) ;
  if (r) {
    fprintf(stderr, "%s\n", stamperror[r]);
    exit(r);
  }

  if (Args->UseFTP) {
    r = Transfer_File(Args) ;
    if (r) {
      fprintf(stderr, "%s\n", stamperror[r]);
      exit(r);
    }
  }
  
  exit(0) ;  
}

int Parse_Stamp_Args(int argc, char **argv, struct ArgStruct *Args) {
  extern int optind ;
  extern char *optarg ;
  extern int opterr ;
  int c ;

  Args->UseFTP = 0 ;

  while (1) {
    int option_index = 0 ;
    static struct option long_options[] =
    {
      {"ftp", 0, 0, 'f'},
      {"help", 0, 0, 'h'},
      {"version", 0, 0, 'v'},
      {"rcfile", 1, 0, 'r'},
      {0, 0, 0, 0}
    };

    c = getopt_long (argc, argv, "fhvr:", long_options, &option_index);

    if (c == -1)
      break;
    
    switch (c) {

    case 'v':
      fprintf(stderr, "\nStamp %s\n", VERSION) ;
      fprintf(stderr, "Copyright (C) 1999 Patrick Keane, Joshua Kirby, Eric Werner\n") ;
      fprintf(stderr, "Stamp comes with NO WARRANTY.  You may redistribute\n");
      fprintf(stderr, "copies of Stamp under the terms of the GNU General\n");
      fprintf(stderr, "Public License.  For more information about these\n") ;
      fprintf(stderr, "matters, see the file named COPYING.\n\n") ;
      fprintf(stderr, "Stamp contains the 'ftplib' library.\n") ;
      fprintf(stderr, "Copyright (C) 1996, 1997 Thomas Pfau\n\n") ;

      exit(0) ;
      break ;
    case 'f':
      Args->UseFTP = 1 ;
      break ;
    case 'r': 
      Args->RCFile = malloc(strlen(optarg) + 1) ;
      strcpy(Args->RCFile, optarg) ; 
      break ;

    default:
      fprintf(stderr, "\n") ;
      fprintf(stderr, "Usage:\n") ;
      fprintf(stderr, "  stamp <options>\n") ;
      fprintf(stderr, "  -f,             --ftp          Use FTP information from stamprc\n") ;
      fprintf(stderr, "  -r [file],      --rcfile       Use [file] for stamprc information\n") ;
      fprintf(stderr, "  -v,             --version      Show version information\n") ;
      fprintf(stderr, "  -h,             --help         This help message\n") ;
      fprintf(stderr, "\nReport bugs to <patrick@cs.pitt.edu> or <pk@style64.org>\n\n") ;
      exit(0) ; 
      break ;
    }
  }
  return(0) ;
}

