#include <stdio.h>
#include <stdlib.h>
#include <jpeglib.h>
#include "../lib/common.h"

void JPG_Shade(int location, struct ArgStruct *Args,
	       struct ImageStruct *Image, int DigitHeight) {
  struct ScanLine *tmp ;
  int scanline, count, x, j ;
  int dig ;
  
  dig = (DigitHeight - (Args->UseColors * BYTES_PER_PIXEL)) ;
  if (location == 0)
    count = dig + 5 ;
  else if (location == 1)
    count = 0 ;

  tmp = Image->FirstLine ;
  scanline = 0 ;  

  while (tmp != NULL) { 
    scanline ++ ;

    if (((location == 0) &&
	 (strcmp(Args->UpperString, "") &&
	  (scanline >= 1 && scanline <= dig + 5))) ||
	((location == 1) &&						   
	 (strcmp(Args->LowerString, "") &&
	  (scanline >= (Image->image_height - dig - 4) &&
	   scanline <= Image->image_height)))) {

      for (x = 0; x <= Image->image_width; x++) {  
	
	if (Args->UseColors) {
	  for (j = 0; j < BYTES_PER_PIXEL; j++) {
	    tmp->line[(x * BYTES_PER_PIXEL) + j] = 
	      ((Args->Colors[j + BYTES_PER_PIXEL] -
		(count * Args->ShadeRate)) >= 0) 
	      ? (Args->Colors[j + BYTES_PER_PIXEL] - (count*Args->ShadeRate))
	      : 0 ;
	  }
	} else {
	  for (j = 0; j < BYTES_PER_PIXEL; j++) {
	    tmp->line[(x * BYTES_PER_PIXEL) + j] =
	      ((tmp->line[(x * BYTES_PER_PIXEL) + j] -
		(count * Args->ShadeRate)) >= 0)
	      ? (tmp->line[(x * BYTES_PER_PIXEL) + j] -
		 (count * Args->ShadeRate))
	      : 0 ;
	  }
	}
      }
      if (location == 0)
	count -- ;
      else if (location == 1)
	count ++ ;
    }

    tmp = tmp->next ; 
  }
}

int JPG_StringPut(char *overlay, int xpos, int location,
		  struct ArgStruct *Args, struct ImageStruct *Image,
		  int DigitHeight, int DigitWidth, char *buf) {

  int scanline = 0 ;
  int i, j, x, y, num, mod, blank, ypos, dig ;
  struct ScanLine *tmp ;
  char *bitmap ;

  bitmap = malloc(strlen(overlay) * DigitWidth * DigitHeight) ;

  j = 0 ;
  x = 0 ;
  dig = 0 ;

  while (j < DigitHeight) {
    blank = 0 ; 

    for (i = 0; i < strlen(overlay); i++) {
      num = buf[(overlay[i] * 32) + j];
      mod = 256 ;

      while (mod != 1) {
	mod /= 2;
	bitmap[x] = (num & mod) ? 0 : 1 ;
	blank = (!bitmap[x] || blank) ? 1 : 0 ;
	x ++ ;
      }
    }

    if (blank == 0) {
      x = x - (DigitWidth * strlen(overlay)) ;
      dig ++ ;
    }

    j++ ; 

  }

  DigitHeight -= dig ;
  
  JPG_Shade(location, Args, Image, DigitHeight) ;

  tmp = Image->FirstLine ;
  scanline = 0 ;
  x = 0 ;
  y = 0 ;
 
  ypos = (location == 0) ? 2 : (Image->image_height - DigitHeight) ;

  while(tmp != NULL) { 

    scanline ++ ;

    if (scanline >= ypos &&
	scanline < (ypos + DigitHeight)) {

      for (y = 0; y < (strlen(overlay) * DigitWidth); y++) {

	if (bitmap[x] == 0) {
	  for (j = 0; j < BYTES_PER_PIXEL; j++) {
	    tmp->line[((xpos + y) * BYTES_PER_PIXEL) + j] = Args->Colors[j] ;
	  }

	  if (Args->Use3D) {

	    if ((((xpos + y + 1) * BYTES_PER_PIXEL) <=
		 (Image->image_width * BYTES_PER_PIXEL))
		&& ((bitmap[x+1] == 1)
		 || (y == ((strlen(overlay) * DigitWidth) - 1))))
	      for (j = 0; j < BYTES_PER_PIXEL; j++) {
		tmp->line[((xpos + y + 1) * BYTES_PER_PIXEL) + j] = BLACK ;
	      }
	    if ((((xpos + y + 2) * BYTES_PER_PIXEL) <=
		 (Image->image_width * BYTES_PER_PIXEL))
		&& (((bitmap[x+1] == 1) && (bitmap[x+2] == 1))
		 || (y == ((strlen(overlay) * DigitWidth) - 1))))
	      for (j = 0; j < BYTES_PER_PIXEL; j++) {
		tmp->line[((xpos + y + 2) * BYTES_PER_PIXEL) + j] = BLACK ;
	      }
	  }
	}
	x++ ;
      }
    }

    tmp = tmp->next ; 

  }

  free(bitmap) ;

  return(0) ;
}


int JPG_Rotate_CCW(struct ImageStruct *Image) {
  struct ScanLine *scanline, *z ;
  int x, y, j ;

  Image->OldFirstLine = Image->FirstLine ;
  Image->OldLastLine = Image->LastLine ;
  Image->FirstLine = Image->LastLine = NULL ;
  
  for (x = Image->image_width; x >= 0; x--) {  
    scanline = malloc(sizeof(JSAMPLE) * Image->image_height * BYTES_PER_PIXEL) ;
    scanline->next = NULL ;
    
    if (Image->FirstLine == NULL) {
      Image->FirstLine = Image->LastLine = scanline ;
    } else {
      Image->LastLine->next = scanline ;
      Image->LastLine = scanline ;
    }
    
    scanline->line =  malloc(sizeof(JSAMPLE) * 
			 Image->image_height *
			 BYTES_PER_PIXEL) ;
    
    z = Image->OldFirstLine ;
    
    for (y = 0; y < Image->image_height; y++) {  
      for (j = 0; j < BYTES_PER_PIXEL; j++) {
	scanline->line[(y * BYTES_PER_PIXEL) + j] =
	  z->line[(x * BYTES_PER_PIXEL) + j] ;
      }
      z = z->next ;
    }
    }
  x = Image->image_height ;
  Image->image_height = Image->image_width ;
  Image->image_width = x ;
  return (0) ;
}

int JPG_Rotate_CW(struct ImageStruct *Image) {
  struct ScanLine *scanline, *z ;
  int x, y, j ;

  x = Image->image_height ;
  Image->image_height = Image->image_width ;
  Image->image_width = x ;
  
  scanline = Image->FirstLine ;
  
  for (x = Image->image_width - 1; x >= 0; x--) {  
    
    z = Image->OldFirstLine ;
    
    for (y = 0; y < Image->image_height; y++) {  
      for (j = 0; j < BYTES_PER_PIXEL; j++) {
	z->line[(x * BYTES_PER_PIXEL) + j] = scanline->line[(y * BYTES_PER_PIXEL) + j] ;
      }
      z = z->next ;
    }
    scanline = scanline->next ;
  }
  Image->FirstLine = Image->OldFirstLine ;
  Image->LastLine = Image->OldLastLine ;
  return (0) ;
}
 

/* Creates a new image in "new" which is the result of placing "front"
   onto "back", with the upper left corner of front at coordinates x,y
   where 0,0 is upper left of back image.
   If clip is true, then the "new" will be clipped to the same size as "back"

   future - rgb of extra space that can be created in "new" if not clipping.
            transparant - let some color in front be transparant, so 
	    pixels of that color in front will not be drawn over pixels in
	    new (which would have back).
*/
/* in all actuality, this function should be called JPG_Stamp. -ebw */
int JPG_Image_onto_Image(struct ImageStruct **new,
			 struct ImageStruct *back, 
			 struct ImageStruct *front, 
			 int x,
			 int y,
			 int clip,
			 int trans_r,
			 int trans_g,
			 int trans_b) {
  
  struct ImageStruct *new_image ;
  struct ScanLine *new_line, *back_line, *front_line; 
  struct ScanLine *current_line ;
  int back_x, back_y;
  int front_x, front_y;
  int min_x, min_y;
  int max_x, max_y;
  int new_width, new_height;
  int back_width, back_height;
  int front_width, front_height;
  int i, j, t;

  /* This is just for convenience */
  back_width = back->image_width ;
  back_height = back->image_height ;
  
  front_width = front->image_width ;
  front_height = front->image_height ;
  
  /* Make the new image */

  /* 1) figure out its dimensions */
  if (clip){
    new_width = back_width;
    new_height = back_height;
  } else {
    /* this is ugly 
       If you really want to figure it out, draw it on some paper 
    */
    new_width = back_width;
    if (x < 0) {
      new_width -= x;
    }
    t = x + front_width;
    if (t > back_width) { 
      new_width += (t - back_width);
    }
    
    new_height = back_height;
    if (y < 0) {
      new_height -= y;
    }
    t = y + front_height;
    if (t > back_height) { 
      new_height += (t - back_height);
    }

    
  }
  
 /* 2) create the new ImageStruct */
  new_image = malloc(sizeof(struct ImageStruct));
  bzero(new_image, sizeof(struct ImageStruct));
  new_image->image_width = new_width;
  new_image->image_height = new_height;


  /* 3) fill in the blank scanlines */
  current_line = NULL;
  
  for (i=0; i<new_height; i++){
    new_line = malloc(sizeof(struct ScanLine));
    bzero(new_line, sizeof(struct ScanLine));
    new_line->line =  malloc(sizeof(JSAMPLE) * new_width * BYTES_PER_PIXEL) ;
    bzero(new_line->line, sizeof(JSAMPLE) * new_width * BYTES_PER_PIXEL);
    new_line->next = NULL;
    if (current_line) {
      current_line->next = new_line;
    } 
    if ( i==0 ) {
      new_image->FirstLine = new_line;
    }
    current_line = new_line;
  }
  new_image->LastLine = current_line;
  

  /* next we put the back image onto the new image. */
  /* this is pretty straight-forward */
  
  /* 1) figure out where the back image starts on the new image */
  back_x = (!clip && x<0)?-x:0;
  back_y = (!clip && y<0)?-y:0;
 
  /* next, get to the first line in the new image
     where the back image will be placed. */
  current_line = new_image->FirstLine;
  for (i=0; i<back_y; i++){
    current_line = current_line->next;
  }
  back_line = back->FirstLine;
  
  /* now, copy the back image onto the new image */
  for(i=0; i<back_height; i++){
    for(j=0; j<back_width; j++){

      current_line->line[ (j + back_x) * BYTES_PER_PIXEL ] = 
	back_line->line[ j * BYTES_PER_PIXEL ];
      
      current_line->line[ (j + back_x) * BYTES_PER_PIXEL + 1 ] = 
	back_line->line[ j * BYTES_PER_PIXEL + 1 ];
      
      current_line->line[ (j + back_x) * BYTES_PER_PIXEL + 2 ] = 
	back_line->line[ j * BYTES_PER_PIXEL + 2 ];
    }
    back_line = back_line->next;
    current_line = current_line->next;
  }
  
  /* Now copy the front image onto the new image. */
  /* This is not quite as stright-forward */
  /* variables: front_x, front_y represent coordinates in the
     new image where the front image will be placed 
     min_? and max_? represent the minimium and maximum x and y
     values of the FRONT image that will be placed onto the new image. 
     All this to allow for clipping. sheesh. :)
  */
  
  if(clip){
    front_x = x;
    front_y = y;
  } else {
    front_x = (x<0)?0:x;
    front_y = (y<0)?0:y;
  }
  
  if (clip) {
    /* this is REALLY ugly.  sorry, but it's the only way to do it
       as far as i can tell */
    
    min_x = (x>0)?0:-x;
    min_y = (y>0)?0:-y;

    max_x = (back_width - x);
    max_x = (max_x > front_width)?front_width:max_x;
      
    max_y = (back_height - y);
    max_y = (max_y > front_height)?front_height:max_y;
  } else {
    min_x = 0;
    min_y = 0;

    max_x = front_width;
    max_y = front_height;
  }
  /* if we end up completely outside the bounds of the new image, 
     just return the new image. */
  if ((clip) &&
      (min_x > front_width) ||
      (min_y > front_height) ||
      (max_x < 0 ) ||
      (max_y < 0) ||
      (front_x > new_width) ||
      (front_y > new_height)
      )
    { 
      *new = new_image ;
      return 0;
    }
  
  /* now actually put the front image onto the new image */

  current_line = new_image->FirstLine;
  for(i=0; (i < front_y); i++){
    current_line = current_line->next;
  }
  
  front_line = front->FirstLine;
  for(i=0; (i < min_y); i++){
    front_line = front_line->next;
  }

  for(i=min_y; i<max_y; i++){
    for(j=min_x; j<max_x; j++){
      
      if ( 
	  (front_line->line[ j * BYTES_PER_PIXEL    ] != trans_r) && 
	  (front_line->line[ j * BYTES_PER_PIXEL + 1] != trans_g) && 
	  (front_line->line[ j * BYTES_PER_PIXEL + 2] != trans_b) 
	  ) {
	
	current_line->line[ (j + front_x) * BYTES_PER_PIXEL ] = 
	  front_line->line[ j * BYTES_PER_PIXEL ];
	
	current_line->line[ (j + front_x) * BYTES_PER_PIXEL + 1 ] = 
	  front_line->line[ j * BYTES_PER_PIXEL + 1 ];
	
	current_line->line[ (j + front_x) * BYTES_PER_PIXEL + 2 ] = 
	  front_line->line[ j * BYTES_PER_PIXEL + 2 ];
      }
    }
      front_line = front_line->next;
      current_line = current_line->next;
  }
  
  /* now we're done. */
  *new = new_image ;
  return 0;
}












