/* Signal Handlers for GTK Stamp Config! 
   Eric Werner - 19 FEB 1999 
   ebw@city-net.com
*/
#include <gtk/gtk.h>
#include <string.h>
#include "gstamp.h"
#include "../lib/rcfile.h"

extern char *stamperror[] ;


void help_about_callback(GtkWidget *w, UI_Struct *ui) {
  char tmpstring[1024];
  
  sprintf(tmpstring, "GTK Stamp - Version %s\n",VERSION); 
  strcat(tmpstring,  "Copyright (C) 1999 Patrick Keane, Joshua Kirby, Eric Werner\nThis program comes with NO WARRANTY.  You may redistribute\ncopies of this program under the terms of the GNU General Public License.\nFor more information about these matters, see the file named COPYING.");
  
  message_set_text(ui, tmpstring);    
  message_show(ui);
}


gint message_delete_event (GtkWidget *w, UI_Struct *ui) {
    gtk_widget_hide (GTK_WIDGET(w));
    gtk_grab_remove(GTK_WIDGET(w));
    return TRUE;
}

void message_ok_sel(GtkWidget *w, UI_Struct *ui){

  gtk_widget_hide(GTK_WIDGET(ui->message->window));
  gtk_grab_remove(GTK_WIDGET(ui->message->window));
  
}

/* delete event for the preview dialog */
gint preview_delete_event(GtkObject *w, UI_Struct *ui){
  gtk_widget_hide (GTK_WIDGET(w));
  return TRUE;
}

/* callback function for the Preview Button */
void preview_callback (GtkWidget * widget, UI_Struct *ui) {
  Preview(ui);
}

void stamp_callback (GtkWidget * widget, UI_Struct *ui) {
 int stamp_return;
 ui_to_args(ui, ui->args);
 stamp_return = gstmp_stampit(ui, ui->args, 0);
 if (stamp_return) {
   message_set_text(ui, stamperror[stamp_return]);    
   message_show(ui);
 }
 return;
}

void stamp_send_callback (GtkWidget * widget, UI_Struct *ui) {
  int stamp_return;
  ui_to_args(ui, ui->args);
  stamp_return = gstmp_stampit(ui, ui->args, 1);
  if (stamp_return) {
    message_set_text(ui, stamperror[stamp_return]);    
    message_show(ui);
  }
  return;
}


/* the close the window and get the hell outta dodge routine */
void main_delete_event (GtkWidget * widget, GdkEvent * event, gpointer data){
  gtk_main_quit ();
}

/* the die die die routine ( does this ever actually get executed? ) */
void main_destroy_event (GtkWidget *widget, gpointer data)
{
  gtk_main_quit ();
}

/* callback for selecting "Yes" in the yes/no dialog */
void yes_no_yes_sel (GtkWidget *w, UI_Struct *ui){
  char *title;
  
  title = g_malloc(sizeof(char) * (strlen(ui->Titlebase) 
				   + strlen(gtk_file_selection_get_filename (GTK_FILE_SELECTION (ui->filew))) + 2));
  strcpy (title, ui->Titlebase);
  strcat(title, gtk_file_selection_get_filename (GTK_FILE_SELECTION (ui->filew)));
  gtk_widget_hide (GTK_WIDGET(ui->yesno->window));
  gtk_grab_remove(GTK_WIDGET(ui->yesno->window));
  gtk_window_set_title (GTK_WINDOW(ui->window), title);
  write_config_file((char *) gtk_file_selection_get_filename (GTK_FILE_SELECTION (ui->filew)), ui);
  g_free(title);
}

/* callback for selecting "No" in the yes/no dialog */
void yes_no_no_sel (GtkWidget *w, UI_Struct *ui) {
  gtk_widget_hide (GTK_WIDGET(ui->yesno->window));
  gtk_grab_remove(GTK_WIDGET(ui->yesno->window));
  main_save_callback (NULL, ui);
}

/* callback for selecting "Cancel" in the yes/no dialog */
void yes_no_cancel_sel (GtkWidget *w, UI_Struct *ui)
{
  gtk_widget_hide (GTK_WIDGET(ui->yesno->window));
  gtk_grab_remove(GTK_WIDGET(ui->yesno->window));
}

/* delete event for the yes/no dialog */
gint yes_no_delete_event(GtkObject *w, UI_Struct *ui){
  gtk_widget_hide (GTK_WIDGET(w));
  gtk_grab_remove(GTK_WIDGET(w));
  return TRUE;
}

void update_callback(GtkWidget * widget, UI_Struct *ui) {
  char tmp[255];
  /* i have to do this because write_config_file rewrites
     ui->RCFile. */
  
  strcpy(tmp, ui->RCFile);
  write_config_file(tmp, ui);
}

/* callback for the "Save" button in the main window*/
void main_save_callback (GtkWidget * widget, UI_Struct *ui) {
  ui->GSTMP_FILE_VISIBLE = TRUE;
  ui->GSTMP_FILE_BUTTON = GSTMP_BROWSE_SAVEAS;
  /* this should take the default rcfile from the args struct */
  gtk_file_selection_set_filename (GTK_FILE_SELECTION (ui->filew), ui->RCFile);
  gtk_widget_show (ui->filew);
  gtk_grab_add(ui->filew);
}

/* callback for the "LOAD" button in the main window*/
void main_load_callback (GtkWidget * widget, UI_Struct *ui) {
  ui->GSTMP_FILE_VISIBLE = TRUE;
  ui->GSTMP_FILE_BUTTON = GSTMP_BROWSE_LOAD;
  /* this should take the default rcfile from the args struct */
  gtk_file_selection_set_filename (GTK_FILE_SELECTION (ui->filew), ui->RCFile);
  gtk_widget_show (ui->filew);
  gtk_grab_add(ui->filew);
}

/* callback for the Input File "Browse" button */
void input_file_browse_callback(GtkWidget *w, UI_Struct *ui){
  gchar *filename;
  ui->GSTMP_FILE_VISIBLE = TRUE;
  ui->GSTMP_FILE_BUTTON = GSTMP_BROWSE_INFILE;

  filename = gtk_entry_get_text (GTK_ENTRY(ui->Infile));
  gtk_file_selection_set_filename (GTK_FILE_SELECTION (ui->filew), filename);
  gtk_widget_show (ui->filew);
  gtk_grab_add(ui->filew);
}

/* callback for the Output File "Browse" button */
void output_file_browse_callback(GtkWidget *w, UI_Struct *ui){
  gchar *filename;
  ui->GSTMP_FILE_VISIBLE = TRUE;
  ui->GSTMP_FILE_BUTTON = GSTMP_BROWSE_OUTFILE;

  filename = gtk_entry_get_text (GTK_ENTRY(ui->Outfile));
  gtk_file_selection_set_filename (GTK_FILE_SELECTION (ui->filew), filename);
  gtk_widget_show (ui->filew);
  gtk_grab_add(ui->filew);
}

/* callback for the Upper Font "Browse" button */
void upper_font_browse_callback(GtkWidget *w, UI_Struct *ui){
  gchar *filename;
  ui->GSTMP_FILE_VISIBLE = TRUE;
  ui->GSTMP_FILE_BUTTON = GSTMP_BROWSE_UPPERFONT;

  filename = gtk_entry_get_text (GTK_ENTRY(ui->UpperFont));
  gtk_file_selection_set_filename (GTK_FILE_SELECTION (ui->filew), filename);
  gtk_widget_show (ui->filew);
  gtk_grab_add(ui->filew);
}

/* callback for the Lower Font "Browse" button */
void lower_font_browse_callback(GtkWidget *w, UI_Struct *ui){
  gchar *filename;
  ui->GSTMP_FILE_VISIBLE = TRUE;
  ui->GSTMP_FILE_BUTTON = GSTMP_BROWSE_LOWERFONT;

  filename = gtk_entry_get_text (GTK_ENTRY(ui->LowerFont));
  gtk_file_selection_set_filename (GTK_FILE_SELECTION (ui->filew), filename);
  gtk_widget_show (ui->filew);
  gtk_grab_add(ui->filew);
}

/* callback for the preview file browse button */
void preview_file_browse_callback(GtkWidget *w, UI_Struct *ui){
  gchar *filename;
  ui->GSTMP_FILE_VISIBLE = TRUE;
  ui->GSTMP_FILE_BUTTON = GSTMP_BROWSE_PREVIEW;
  
  filename = gtk_entry_get_text (GTK_ENTRY(ui->Previewfile));
  gtk_file_selection_set_filename (GTK_FILE_SELECTION (ui->filew), filename);
  gtk_widget_show (ui->filew);
  gtk_grab_add(ui->filew);
}

/* delete event callback for file dialog */
gint file_delete_event(GtkWidget *w, UI_Struct *ui){
  ui->GSTMP_FILE_VISIBLE = FALSE;
  ui->GSTMP_FILE_BUTTON = 0;
  gtk_widget_hide (GTK_WIDGET(w));
  gtk_grab_remove(GTK_WIDGET(w));
  return TRUE;
}

/* callback for the "Cancel" button on the file dialog */
void file_cancel_sel (GtkWidget *w, UI_Struct *ui){
  ui->GSTMP_FILE_VISIBLE = FALSE;
  ui->GSTMP_FILE_BUTTON = 0;
  gtk_widget_hide (GTK_WIDGET(ui->filew));
  gtk_grab_remove(GTK_WIDGET(ui->filew));
}

/* callback for the "Ok" button on the file dialog */
void file_ok_sel (GtkWidget *w, UI_Struct *ui)
{

  char *filename;
  const char *q1 = " exists, overwrite?";
  char *fullquestion;
  FILE *file;
  char *title;
	
  gtk_widget_hide(GTK_WIDGET(ui->filew));
  gtk_grab_remove(GTK_WIDGET(ui->filew));

  filename = (char *) gtk_file_selection_get_filename (GTK_FILE_SELECTION (ui->filew));
  /* handle the case for SAVE RC */
  if (ui->GSTMP_FILE_BUTTON == GSTMP_BROWSE_SAVEAS) {
    file = fopen(filename, "r");
    if (file != NULL){
      ui->GSTMP_FILE_VISIBLE = FALSE;
      ui->GSTMP_FILE_BUTTON = 0;
      fclose (file);
      yes_no_set_title(ui, "Overwrite existing file?");
      fullquestion = (char *) g_malloc(sizeof (char) * (strlen(q1) + strlen(filename) + 1));
      strcpy (fullquestion, filename);
      strcat (fullquestion, q1);
      yes_no_set_question(ui, fullquestion);
      yes_no_show(ui);
    } else {
      title = g_malloc(sizeof(char) * (strlen(ui->Titlebase) 
				       + strlen(filename) + 2));
      strcpy (title, ui->Titlebase);
      strcat(title, filename);
      gtk_window_set_title (GTK_WINDOW(ui->window), title);
      write_config_file(filename, ui);
      g_free(title);
    }
  }
  /* SETTING INFILE */
  else if (ui->GSTMP_FILE_BUTTON == GSTMP_BROWSE_INFILE) {
    ui->GSTMP_FILE_VISIBLE = FALSE;
    ui->GSTMP_FILE_BUTTON = 0;
    gtk_entry_set_text (GTK_ENTRY(ui->Infile), (gchar *)filename );

  } 
  /* SETTING OUTFILE */
  else if (ui->GSTMP_FILE_BUTTON == GSTMP_BROWSE_OUTFILE) {
    ui->GSTMP_FILE_VISIBLE = FALSE;
    ui->GSTMP_FILE_BUTTON = 0;
    gtk_entry_set_text (GTK_ENTRY(ui->Outfile), (gchar *)filename);
  } 
  /* SETTING UPPERFONT */
  else if (ui->GSTMP_FILE_BUTTON == GSTMP_BROWSE_UPPERFONT) {
    ui->GSTMP_FILE_VISIBLE = FALSE;
    ui->GSTMP_FILE_BUTTON = 0;
    gtk_entry_set_text (GTK_ENTRY(ui->UpperFont), (gchar *)filename); 
  } 
  /* SETTING LOWERFONT */
  else if (ui->GSTMP_FILE_BUTTON == GSTMP_BROWSE_LOWERFONT) {
    ui->GSTMP_FILE_VISIBLE = FALSE;
    ui->GSTMP_FILE_BUTTON = 0;
    gtk_entry_set_text (GTK_ENTRY(ui->LowerFont), (gchar *)filename);
  } 
  /* SETTING PREVIEWFILE */
  else if (ui->GSTMP_FILE_BUTTON == GSTMP_BROWSE_PREVIEW) {
    ui->GSTMP_FILE_VISIBLE = FALSE;
    ui->GSTMP_FILE_BUTTON = 0;
    gtk_entry_set_text (GTK_ENTRY(ui->Previewfile), (gchar *)filename);
  } 
  /* LOAD RC FILE */
  else if (ui->GSTMP_FILE_BUTTON == GSTMP_BROWSE_LOAD) {
    ui->GSTMP_FILE_VISIBLE = FALSE;
    ui->GSTMP_FILE_BUTTON = 0;
    g_free(ui->args->RCFile);
    ui->args->RCFile = (char *)malloc(sizeof(char) * strlen(filename) + 1);
    strcpy(ui->args->RCFile, filename);
    RC_load(ui->args);
    args_to_ui(ui->args, ui);
    title = g_malloc(sizeof(char) * (strlen(ui->Titlebase) 
				     + strlen(filename) + 2));
    strcpy (title, ui->Titlebase);
    strcat(title, filename);
    gtk_window_set_title (GTK_WINDOW(ui->window), title);
    g_free(title);
  }
  
}


/* delete event for color picker dialog */
gint color_delete_event(GtkObject *w, UI_Struct *ui){
  ui->GSTMP_COLOR_VISIBLE = FALSE;
  ui->GSTMP_CURRENT_COLOR_BUTTON = 0;
  gtk_widget_hide (GTK_WIDGET(w));
  gtk_grab_remove(GTK_WIDGET(w));
  return TRUE;
}

/* callback for the "Cancel" button on the color dialog */ 
void color_cancel_sel(GtkWidget *w, UI_Struct *ui)
{
  ui->GSTMP_COLOR_VISIBLE = FALSE;
  ui->GSTMP_CURRENT_COLOR_BUTTON = 0;
  gtk_widget_hide (ui->ColorSel);
  gtk_grab_remove(ui->ColorSel);
}

/* callback for the Foreground Color button */ 
void color_callback_1(GtkWidget *w, UI_Struct *ui){
  GtkStyle *style;
  gdouble colors[3];

  ui->GSTMP_COLOR_VISIBLE = TRUE;
  ui->GSTMP_CURRENT_COLOR_BUTTON = 1;
  style = gtk_widget_get_style(ui->ColorButton1);
  colors[0] = ((gdouble) style->bg[GTK_STATE_NORMAL].red )/65535.0;
  colors[1] = ((gdouble) style->bg[GTK_STATE_NORMAL].green )/65535.0;
  colors[2] = ((gdouble) style->bg[GTK_STATE_NORMAL].blue )/65535.0;
  gtk_color_selection_set_color (GTK_COLOR_SELECTION(GTK_COLOR_SELECTION_DIALOG(ui->ColorSel)->colorsel),colors);
  
  gtk_widget_show (ui->ColorSel);
  gtk_grab_add(ui->ColorSel);
}

/* callback for the Background Color button */ 
void color_callback_2(GtkWidget *w, UI_Struct *ui){
  GtkStyle *style;
  gdouble colors[3];

  ui->GSTMP_COLOR_VISIBLE = TRUE;
  ui->GSTMP_CURRENT_COLOR_BUTTON = 2;
  style = gtk_widget_get_style(ui->ColorButton2);
  colors[0] = ((gdouble) style->bg[GTK_STATE_NORMAL].red )/65535.0;
  colors[1] = ((gdouble) style->bg[GTK_STATE_NORMAL].green )/65535.0;
  colors[2] = ((gdouble) style->bg[GTK_STATE_NORMAL].blue )/65535.0;
  gtk_color_selection_set_color (GTK_COLOR_SELECTION(GTK_COLOR_SELECTION_DIALOG(ui->ColorSel)->colorsel),colors);
  
  gtk_widget_show (ui->ColorSel);
  gtk_grab_add(ui->ColorSel);
}

/* no clue - but was in the tutorial.  Think it updates the color dialog */
void color_selection_changed (GtkWidget *w, GtkColorSelectionDialog *cs)
{
  GtkColorSelection *colorsel;
  gdouble color[4];
  colorsel=GTK_COLOR_SELECTION(cs->colorsel);
  gtk_color_selection_get_color(colorsel,color);
}

/* callback for the "Ok" button in the Color Picker Dialog */
void color_changed(GtkWidget *w, UI_Struct *ui){
  gdouble color[3];

  gtk_color_selection_get_color (GTK_COLOR_SELECTION(GTK_COLOR_SELECTION_DIALOG(ui->ColorSel)->colorsel),color);
  if ( ui->GSTMP_CURRENT_COLOR_BUTTON == 1 )
    set_color(ui->ColorButton1, color);
  else
    set_color(ui->ColorButton2, color);
  gtk_widget_hide (GTK_WIDGET(ui->ColorSel));
  gtk_grab_remove(GTK_WIDGET(ui->ColorSel));

  ui->GSTMP_CURRENT_COLOR_BUTTON = 0;
  ui->GSTMP_COLOR_VISIBLE = TRUE;
}










