/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <X11/Intrinsic.h>
#include "ResourceDB.hh"
#include <X11/StringDefs.h>

static XtResource rdb_items[] = {
  /* idx = 0 */
  {(char*)"engineModule", (char*)"EngineModule", XtRString, sizeof(char*),
   offsetof(RmDatabase, if_name), XtRString, (XPointer)""},
  {(char*)"conversionOnKeys", (char*)"ConversionOnKeys", XtRString, sizeof(char*), 
   offsetof(RmDatabase, conv_keys), XtRString, (XPointer)"<Ctrl>space"},
  {(char*)"portNumber", (char*)"PortNumber", XtRString, sizeof(char*),
   offsetof(RmDatabase, port_number), XtRString, (XPointer)"9010"},

  /* idx = 10 */
  {XtNbackground, XtCBackground, XtRPixel, sizeof(unsigned long),
   offsetof(RmDatabase, background), XtRString, (XPointer) "white"}, 
  {XtNforeground, XtCForeground, XtRPixel, sizeof(unsigned long),
   offsetof(RmDatabase, foreground), XtRString, (XPointer) "black"}, 
  {(char*)"fontSet", (char*)"FontSet", XtRString, sizeof(char *),
   offsetof(RmDatabase, fontset), XtRString, (XPointer) "-*-*-medium-*-*-*-*-*-*-*-*-*-*-*"},

  /* idx = 20 */
  {(char*)"rootTitle", (char*)"RootTitle", XtRBool, sizeof(Bool),
   offsetof(RmDatabase, has_root_title), XtRString, (XPointer) "true"},
  {(char*)"rootTitleName", (char*)"RootTitleName", XtRString, sizeof(char*),
   offsetof(RmDatabase, root_title), XtRString, (XPointer) "Input Method Server"},
  {(char*)"rootGeometry", (char*)"RootGeometry", XtRString, sizeof(char *),
   offsetof(RmDatabase, root_geom), XtRString, (XPointer)"1110x40+10+800"},
  {(char*)"rootPlacement", (char*)"RootPlacement", XtRString, sizeof(char *),
   offsetof(RmDatabase, root_place), XtRString, (XPointer) "bottom"},
  {(char*)"rootPosition", (char*)"RootPosition", XtRString, sizeof(char *),
   offsetof(RmDatabase, root_position), XtRString, (XPointer) "client"},
  {(char*)"rootLayout", (char*)"RootLayout", XtRString, sizeof(char *),
   offsetof(RmDatabase, root_layout), XtRString, (XPointer )"normal"},

  /* idx = 30 */
  {(char*)"statusPlacement", (char*)"StatusPlacement", XtRString, sizeof(char *),
   offsetof(RmDatabase, status_place), XtRString, (XPointer) "bottom"},
  {(char*)"statusPosition", (char*)"StatusPosition", XtRString, sizeof(char *),
   offsetof(RmDatabase, status_position), XtRString, (XPointer) "client"},
  {(char*)"statusMaxWidth", (char*)"StatusMaxWidth", XtRInt, sizeof(int),
   offsetof(RmDatabase, status_max_width), XtRImmediate, (XPointer) 8},
  {(char*)"statusDisplay", (char*)"StatusDisplay", XtRString, sizeof(char *),
   offsetof(RmDatabase, root_display), XtRString, (XPointer)"ondemand"},
  {(char*)"preeditAutoWrap", (char*)"PreeditAutoWrap", XtRString, sizeof(char *),
   offsetof(RmDatabase, preedit_move), XtRString, (XPointer)"wrap"},
  {(char*)"preeditUseArrow", (char*)"PreeditUseArrow", XtRString, sizeof(char *),
   offsetof(RmDatabase, preedit_usearrow), XtRString, (XPointer)"true"},
  {(char*)"rootStatusGeometry", (char*)"RootStatusGeometry", XtRString, sizeof(char *),
   offsetof(RmDatabase, root_status_geom), XtRString, (XPointer) "100X40+0+0"},

  /* idx = 40 */
  {(char*)"lookupLabelType", (char*)"LookupLabelType", XtRString, sizeof(char*),
   offsetof(RmDatabase, lookup_label), XtRString, (XPointer)"lower"},
  {(char*)"lookupRow", (char*)"LookupRow", XtRInt, sizeof(int),
   offsetof(RmDatabase, lookup_rows), XtRImmediate, (XPointer)4},
  {(char*)"lookupColumn", (char*)"LookupColumn", XtRInt, sizeof(int),
   offsetof(RmDatabase, lookup_columns), XtRImmediate, (XPointer)6},
  {(char*)"lookupBackground", (char*)"LookupBackground", XtRString, sizeof(char *),
   offsetof(RmDatabase, lookup_bg_str), XtRString, (XPointer)"white"},
  {(char*)"lookupForeground", (char*)"LookupForeground", XtRString, sizeof(char *),
   offsetof(RmDatabase, lookup_fg_str), XtRString, (XPointer)"black"},
  {(char*)"lookupPlacement", (char*)"LookupPlacement", XtRString, sizeof(char *),
   offsetof(RmDatabase, lookup_place), XtRString, (XPointer) "bottom"},
  {(char*)"lookupPosition", (char*)"LookupPosition", XtRString, sizeof(char *),
   offsetof(RmDatabase, lookup_position), XtRString, (XPointer)"client"},
  {(char*)"lookupWindowType", (char*)"LookupWindowType", XtRString, sizeof(char *),
   offsetof(RmDatabase, lookup_window), XtRString, (XPointer)"popup"},
  {(char*)"lookupPolicy", (char*)"LookupPolicy", XtRString, sizeof(char *),
   offsetof(RmDatabase, lookup_policy), XtRString, (XPointer)"share"},
  {(char*)"lookupTitle", (char*)"LookupTitle", XtRBool, sizeof(Bool), 
   offsetof(RmDatabase, has_lookup_title), XtRString, (XPointer)"true"},
  {(char*)"lookupTitleName", (char*)"LookupTitleName", XtRString, sizeof(char*), 
   offsetof(RmDatabase, lookup_title), XtRString, (XPointer)"SelectionWindow"},
  {(char*)"hotkeys", (char*)"Hotkeys", XtRString, sizeof(char*), 
   offsetof(RmDatabase, hotkey_string), XtRString, (XPointer)0},

  /* hidden resources  */
  {(char*)"modeShellDecoration", (char*)"ModeShellDecoration", XtRBool, sizeof(Bool), 
   offsetof(RmDatabase, has_decoration), XtRString, (XPointer)"true"},
  {(char*)"usedefaultcolors", (char*)"useDefaultColors", XtRBool, sizeof(Bool),
   offsetof(RmDatabase, use_default_colors), XtRString, (XPointer) "false"},

  /* disable status area for IM engines which uses floating AuxPalette */
  {(char*)"disableStatusArea", (char*)"DisableStatusArea", XtRBool, sizeof(Bool),
   offsetof(RmDatabase, disable_status_area), XtRString, (XPointer) "false"}
};

ResourceDB::ResourceDB(Widget toplevel) {
  XtGetApplicationResources(toplevel, (char*)&rdb,
			    rdb_items, XtNumber(rdb_items),
			    0, 0);
}

int
ResourceDB::getValues(IMArg *args, unsigned int n) {
  for (IMArg *argp = args; argp < &args[n]; argp++) {
    switch (argp->id) {
    case RDB_CONV_ON_KEY:
      {
	char **pp = (char**)argp->value;
	*pp = (char *)XtMalloc(strlen(rdb.conv_keys) + 1);
	if (!*pp) return RDB_CONV_ON_KEY;
	strcpy(*pp, rdb.conv_keys);
	break;
      }
    case RDB_IF_NAME:
      {
	char **pp = (char**)argp->value;
	*pp = (char *)XtMalloc(strlen(rdb.if_name) + 1);
	if (!*pp) return RDB_IF_NAME;
	strcpy(*pp, rdb.if_name);
	break;
      }
    case RDB_FS_NAME:
      {
	char **pp = (char**)argp->value;
	*pp = (char *)XtMalloc(strlen(rdb.fontset) + 1);
	if (!*pp) return RDB_FS_NAME;
	strcpy(*pp, rdb.fontset);
	break;
      }
    case RDB_DISABLE_STATUS_AREA:
      {
	char **pp = (char**)argp->value;
	*pp = (char*)rdb.disable_status_area;
	break;
      }
      
    default:
      break;
    }
  }
  return 0;
}
