/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include "FrameMgr.h"

/* Data type definitions */
xim_externaldef
XimFrameRec worddata_fr[] = {
    _FRAME(BIT16),	/* value */
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec longdata_fr[] = {
    _FRAME(BIT32),	/* value */
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec xrectangle_fr[] = {
    _FRAME(BIT16),	/* X */
    _FRAME(BIT16),	/* Y */
    _FRAME(BIT16),	/* width */
    _FRAME(BIT16),	/* height */
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec xpoint_fr[] = {
    _FRAME(BIT16),	/* X */
    _FRAME(BIT16),	/* Y */
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec xfontset_fr[] = {
    _FRAME(BIT16),	/* length of Base font name */
    _FRAME(BARRAY),	/* Base font name list */
    _PAD4(2),		/* unused */
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec attr_head_fr[] = {
    _FRAME(BIT16),	/* attribute id */
    _FRAME(BIT16),	/* attribute length */
    _FRAME(EOL),
};

/* Composite data type definitions */

static
XimFrameRec char_fr[] = {
    _FRAME(BIT8),
    _FRAME(BIT8),
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec string_fr[] = {
    _BYTE_COUNTER(BIT16, 1),	/* byte length of attribute names */
    _FRAME(ITER),		/* UCS-2 string */
    _FRAME(POINTER),
    _PTR(char_fr),
    _PAD4(2),
    _FRAME(EOL),
};

static
XimFrameRec feedback_attr_fr[] = {
    _FRAME(BIT32),		/* Feedback ID */
    _FRAME(BIT32),	/* value */
    _FRAME(EOL),
};

static
XimFrameRec char_with_feedback_fr[] = {
    _FRAME(BIT8),		/* 1st byte of UCS-2 character */
    _FRAME(BIT8),		/* 2nd byte of UCS-2 character */
    _BYTE_COUNTER(BIT16, 1),	/* byte length of feedback attribute */
    _FRAME(ITER),		/* feedback attribute */
    _FRAME(POINTER),
    _PTR(feedback_attr_fr),
    _FRAME(EOL),
};

static
XimFrameRec operation_fr[] = {
  _FRAME(POINTER),
  _PTR(string_fr),		/* operation identifier */
  _FRAME(BIT16),		/* value length */
  _FRAME(BARRAY),		/* value */
  _PAD4(1),
  _FRAME(EOL),
};

static
XimFrameRec annotation_value_fr[] = {
    _FRAME(BIT32),		/* start index */
    _FRAME(BIT32),		/* end index */
    _FRAME(BIT32),		/* value length */
    _FRAME(BARRAY),             /* value */
    _PAD4(1),
    _FRAME(EOL),
};

static
XimFrameRec annotation_fr[] = {
    _FRAME(BIT32),		/* Attribute ID */
    _BYTE_COUNTER(BIT32, 1),	/* byte length of list of annotation value */
    _FRAME(ITER),		/* text */
    _FRAME(POINTER),
    _PTR(annotation_value_fr),
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec text_fr[] = {
    _BYTE_COUNTER(BIT32, 1),	/* byte length of text */
    _FRAME(ITER),		/* text */
    _FRAME(POINTER),
    _PTR(char_with_feedback_fr),
#ifdef NEED_ANNOTATION
    _BYTE_COUNTER(BIT32, 1),	/* byte length of list of annotation */
    _FRAME(ITER),		/* text */
    _FRAME(POINTER),
    _PTR(annotation_fr),
#else
    _FRAME(BIT32),		/* byte length of list of annotation */
#endif
    _FRAME(EOL),
};

static
XimFrameRec attribid_fr[] = {
    _FRAME(BIT16),
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec clientdescriptor_fr[] = {
    _FRAME(POINTER),
    _PTR(string_fr),		/* application name */
    _FRAME(POINTER),
    _PTR(string_fr),		/* operation system name */
    _FRAME(POINTER),
    _PTR(string_fr),		/* operation system architecture */
    _FRAME(POINTER),
    _PTR(string_fr),		/* operation system version */
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec objectdescriptor_fr[] = {
    _FRAME(BIT16),		/* Object category */
    _PAD4(1),			/* unused */
    _FRAME(BIT32),		/* Object size */
    _FRAME(POINTER),
    _PTR(attribid_fr),		/* Predefined attribute ID */
    _FRAME(POINTER),
    _PTR(attribid_fr),		/* Dynamically assigned attribute ID */
    _FRAME(POINTER),
    _PTR(string_fr),		/* Object name in reversed domain unique name */
    _FRAME(POINTER),
    _PTR(string_fr),		/* Object description in HRN */
    _FRAME(POINTER),
    _PTR(string_fr),		/* Object Signature */
    _FRAME(POINTER),
    _PTR(string_fr),		/* Object User */
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec ccdef_fr[] = {
    _FRAME(POINTER),
    _PTR(string_fr),		/* contents of ccdef */
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec language_fr[] = {
    _FRAME(POINTER),
    _PTR(string_fr),		/* HR Name of language */
    _FRAME(POINTER),
    _PTR(string_fr),		/* language identifier */
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec jarfileobject_fr[] = {
    _BYTE_COUNTER(BIT32, 1),	/* byte length of class name list */
    _FRAME(ITER),		/* class names */
    _FRAME(POINTER),
    _PTR(string_fr),
    _FRAME(BIT32),		/* byte length of jar file */
    _FRAME(BARRAY),             /* value */
    _PAD4(1),
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec binfileobject_fr[] = {
    _FRAME(POINTER),
    _PTR(string_fr),		/* pathname */
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec inputmethod_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _PAD4(1),			/* unused */
    _FRAME(POINTER),
    _PTR(string_fr),		/* HR Name of input method */
    _FRAME(POINTER),
    _PTR(string_fr),		/* input method identifier */
    _BYTE_COUNTER(BIT32, 1),	/* byte length of supported language list */
    _FRAME(ITER),		/* supported language names */
    _FRAME(POINTER),
    _PTR(language_fr),
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec textlist_header_fr[] = {
    _FRAME(BIT32),	/* byte length of text list */
    _FRAME(EOL),
};

static
XimFrameRec imattribute_fr[] = {
    _FRAME(BIT16),		/* attribute ID */
    _PAD4(1),			/* unused */
    _FRAME(BIT32),		/* value length */
    _FRAME(BARRAY),             /* value */
    _PAD4(1),
    _FRAME(EOL),
};

static
XimFrameRec icattribute_fr[] = {
    _FRAME(BIT16),		/* attribute ID */
    _FRAME(BIT16),		/* value length */
    _FRAME(BARRAY),             /* value */
    _PAD4(1),
    _FRAME(EOL),
};

#ifdef LOOKUPSTYLE
static
XimFrameRec lookupstyle_fr[] = {
    _FRAME(BIT32),	/* lookupStyle */
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec lookupstyles_fr[] = {
    _BYTE_COUNTER(BIT16, 2),	/* number of lookupStyle list */
    _PAD4(1),			/* unused */
    _FRAME(ITER),		/* LookupStyle list */
    _FRAME(POINTER),
    _PTR(lookupstyle_fr),
    _FRAME(EOL),
};
#endif

static
XimFrameRec keyevent_fr[] = {
    _FRAME(BIT32),	/* keycode */
    _FRAME(BIT32),	/* keychar */
    _FRAME(BIT32),	/* modifiers */
    _FRAME(BIT32),	/* time stamp */
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec keyevent_list_fr[] = {
    _BYTE_COUNTER(BIT32, 1),	/* byte length of list of keyevents */
    _FRAME(ITER),
    _FRAME(POINTER),
    _PTR(keyevent_fr),
    _FRAME(EOL),
};

/* Protocol Packet frames */

xim_externaldef
XimFrameRec im_packet_header_fr[] = {
    _FRAME(BIT8),		/* type and opcode */
    _FRAME(BIT8),		/* 23-17 bits of length field */
    _FRAME(BIT8),		/* 15-08 bits of length field */
    _FRAME(BIT8),		/* 07-00 bits of length field */
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_connect_fr[] = {
    _FRAME(BIT8),		/* byte order */
    _FRAME(BIT8),		/* protocol-version */
    _FRAME(POINTER),
    _PTR(string_fr),		/* user name */
    _BYTE_COUNTER(BIT16, 1),	/* byte length of auth-protocol-names */
    _FRAME(ITER),		/* auto-protocol names */
    _FRAME(POINTER),
    _PTR(string_fr),
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_connect_reply_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _BYTE_COUNTER(BIT16, 1),	/* byte length of language identifiers */
    _FRAME(ITER),		/* language identifiers */
    _FRAME(POINTER),
    _PTR(string_fr),
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_disconnect_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _PAD4(1),			/* unused */
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_disconnect_reply_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _PAD4(1),			/* unused */
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_register_triggerkeys_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _PAD4(1),			/* unused */
    _BYTE_COUNTER(BIT32, 1),	/* byte length of on-keys */
    _FRAME(ITER),		/* on-keys list */
    _FRAME(POINTER),
    _PTR(keyevent_fr),
    _BYTE_COUNTER(BIT32, 1),	/* byte length of off-keys */
    _FRAME(ITER),		/* off-keys list */
    _FRAME(POINTER),
    _PTR(keyevent_fr),
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_trigger_notify_fr[] = {
    _FRAME(BIT16),		/* input-mehotd-ID */
    _FRAME(BIT16),		/* input-context-ID */
    _FRAME(BIT16),		/* flag */
    _PAD4(1),			/* unused */
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_trigger_notify_reply_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _PAD4(1),			/* unused */
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_setimvalues_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _PAD4(1),			/* unused */
    _BYTE_COUNTER(BIT32, 1),	/* byte length of im-attributes */
    _FRAME(ITER),		/* im-attributes */
    _FRAME(POINTER),
    _PTR(imattribute_fr),
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_setimvalues_reply_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _PAD4(1),			/* unused */
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_getimvalues_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _PAD4(1),			/* unused */
    _BYTE_COUNTER(BIT32, 1),	/* byte length of im-attribute-id */
    _FRAME(ITER),		/* im-attribute-id */
    _FRAME(BIT16),
    _PAD4(1),			/* unused */
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_getimvalues_reply_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _PAD4(1),			/* unused */
    _BYTE_COUNTER(BIT32, 1),	/* byte length of im-attribute */
    _FRAME(ITER),		/* im-attribute */
    _FRAME(POINTER),
    _PTR(imattribute_fr),
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_createic_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _BYTE_COUNTER(BIT16, 1),	/* byte length of ic-attributes */
    _FRAME(ITER),		/* ic-attributes */
    _FRAME(POINTER),
    _PTR(icattribute_fr),
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_createic_reply_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _FRAME(BIT16),		/* input-context-ID */
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_destroyic_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _FRAME(BIT16),		/* input-context-ID */
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_destroyic_reply_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _FRAME(BIT16),		/* input-context-ID */
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_seticvalues_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _FRAME(BIT16),		/* input-context-ID */
    _BYTE_COUNTER(BIT16, 1),	/* byte length of ic-attributes */
    _FRAME(ITER),		/* ic-attributes */
    _FRAME(POINTER),
    _PTR(icattribute_fr),
    _PAD4(2),			/* unused */
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_seticvalues_reply_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _FRAME(BIT16),		/* input-context-ID */
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_geticvalues_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _FRAME(BIT16),		/* input-context-ID */
    _BYTE_COUNTER(BIT16, 1),	/* byte length of ic-attribute-id */
    _FRAME(ITER),		/* ic-attribute-id */
    _FRAME(BIT16),
    _PAD4(2),			/* unused */
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_geticvalues_reply_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _FRAME(BIT16),		/* input-context-ID */
    _BYTE_COUNTER(BIT16, 1),	/* byte length of ic-attribute */
    _FRAME(ITER),		/* ic-attribute */
    _FRAME(POINTER),
    _PTR(icattribute_fr),
    _PAD4(2),			/* unused */
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_seticfocus_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _FRAME(BIT16),		/* input-context-ID */
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_seticfocus_reply_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _FRAME(BIT16),		/* input-context-ID */
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_unseticfocus_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _FRAME(BIT16),		/* input-context-ID */
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_unseticfocus_reply_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _FRAME(BIT16),		/* input-context-ID */
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_resetic_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _FRAME(BIT16),		/* input-context-ID */
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_resetic_reply_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _FRAME(BIT16),		/* input-context-ID */
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_preedit_start_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _FRAME(BIT16),		/* input-context-ID */
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_preedit_start_reply_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _FRAME(BIT16),		/* input-context-ID */
    _FRAME(BIT32),		/* return value */
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_preedit_draw_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _FRAME(BIT16),		/* input-context-ID */
    _FRAME(BIT32),		/* caret */
    _FRAME(BIT32),		/* chg_first */
    _FRAME(BIT32),		/* chg_length */
    _FRAME(BIT32),		/* type = #0 : STRING */
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_preedit_draw_string_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _FRAME(BIT16),		/* input-context-ID */
    _FRAME(BIT32),		/* caret */
    _FRAME(BIT32),		/* chg_first */
    _FRAME(BIT32),		/* chg_length */
    _FRAME(BIT32),		/* type = #0 : STRING */
    _FRAME(POINTER),
    _PTR(string_fr),
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_preedit_draw_text_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _FRAME(BIT16),		/* input-context-ID */
    _FRAME(BIT32),		/* caret */
    _FRAME(BIT32),		/* chg_first */
    _FRAME(BIT32),		/* chg_length */
    _FRAME(BIT32),		/* type = #1 : TEXT */
    _FRAME(POINTER),
    _PTR(text_fr),
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_preedit_draw_reply_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _FRAME(BIT16),		/* input-context-ID */
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_preedit_caret_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _FRAME(BIT16),		/* input-context-ID */
    _FRAME(BIT32),		/* position */
    _FRAME(BIT32),		/* direction */
    _FRAME(BIT32),		/* style */
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_preedit_caret_reply_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _FRAME(BIT16),		/* input-context-ID */
    _FRAME(BIT32),		/* position */
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_preedit_done_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _FRAME(BIT16),		/* input-context-ID */
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_preedit_done_reply_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _FRAME(BIT16),		/* input-context-ID */
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_status_start_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _FRAME(BIT16),		/* input-context-ID */
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_status_start_reply_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _FRAME(BIT16),		/* input-context-ID */
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_status_draw_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _FRAME(BIT16),		/* input-context-ID */ 
    _FRAME(BIT32),		/* type = #1 : TEXT */ 
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_status_draw_string_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _FRAME(BIT16),		/* input-context-ID */ 
    _FRAME(BIT32),		/* type = #0 : STRING */ 
    _FRAME(POINTER),
    _PTR(string_fr),
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_status_draw_text_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _FRAME(BIT16),		/* input-context-ID */ 
    _FRAME(BIT32),		/* type = #1 : TEXT */ 
    _FRAME(POINTER),
    _PTR(text_fr),
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_status_draw_reply_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _FRAME(BIT16),		/* input-context-ID */
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_status_done_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _FRAME(BIT16),		/* input-context-ID */
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_status_done_reply_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _FRAME(BIT16),		/* input-context-ID */
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_lookup_start_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _FRAME(BIT16),		/* input-context-ID */
    _FRAME(BIT16),		/* which is master */
    _FRAME(BIT16),		/* choice per window */
    _FRAME(BIT16),		/* number of rows */
    _FRAME(BIT16),		/* number of columns */
    _FRAME(BIT16),		/* drawing up direction */
    _FRAME(BIT16),		/* which owns label */
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_lookup_start_reply_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _FRAME(BIT16),		/* input-context-ID */
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_lookup_draw_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _FRAME(BIT16),		/* input-context-ID */
    _FRAME(BIT32),		/* index of first candidate */ 
    _FRAME(BIT32),		/* index of last candidate */ 
    _FRAME(BIT32),		/* index of current candidate */ 

    _BYTE_COUNTER(BIT32, 1),	/* byte length of choice list */
    _FRAME(ITER),
    _FRAME(POINTER),
    _PTR(text_fr),		/* choice list */

    _BYTE_COUNTER(BIT32, 1),	/* byte length of index label list */
    _FRAME(ITER),
    _FRAME(POINTER),
    _PTR(text_fr),		/* index label list */

    _FRAME(POINTER),
    _PTR(text_fr),		/* title */
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_lookup_draw_reply_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _FRAME(BIT16),		/* input-context-ID */
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_lookup_done_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _FRAME(BIT16),		/* input-context-ID */
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_lookup_done_reply_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _FRAME(BIT16),		/* input-context-ID */
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_lookup_process_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _FRAME(BIT16),		/* input-context-ID */

    _FRAME(BIT16),		/* type = #0 : INDEX, #1 : PAGE */ 
    _FRAME(BIT16),		/* index of selected choice or page # */
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_lookup_process_reply_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _FRAME(BIT16),		/* input-context-ID */
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_forward_event_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _FRAME(BIT16),		/* input-context-ID */
    _FRAME(BIT32),		/* type */ 
    _FRAME(EOL),
};

#if 0
xim_externaldef
XimFrameRec im_forward_event_string_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _FRAME(BIT16),		/* input-context-ID */
    _FRAME(BIT32),		/* type = #0 : STRING */ 
    _FRAME(POINTER),
    _PTR(string_fr),
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_forward_event_text_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _FRAME(BIT16),		/* input-context-ID */
    _FRAME(BIT32),		/* type = #1 : TEXT */ 
    _FRAME(POINTER),
    _PTR(text_fr),
    _FRAME(EOL),
};
#endif

xim_externaldef
XimFrameRec im_forward_event_keyevent_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _FRAME(BIT16),		/* input-context-ID */
    _FRAME(BIT32),		/* type = #2 : KEYEVENT */ 
    _BYTE_COUNTER(BIT32, 1),	/* byte length of list of keyevents */
    _FRAME(ITER),
    _FRAME(POINTER),
    _PTR(keyevent_fr),
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_forward_event_reply_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _FRAME(BIT16),		/* input-context-ID */
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_commit_string_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _FRAME(BIT16),		/* input-context-ID */
    _FRAME(BIT32),		/* type = #1 : TEXT */ 
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_commit_string_string_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _FRAME(BIT16),		/* input-context-ID */
    _FRAME(BIT32),		/* type = #0 : STRING */ 
    _FRAME(POINTER),
    _PTR(string_fr),
    _FRAME(EOL),
};

#if 0
xim_externaldef
XimFrameRec im_commit_string_text_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _FRAME(BIT16),		/* input-context-ID */
    _FRAME(BIT32),		/* type = #1 : TEXT */ 
    _FRAME(POINTER),
    _PTR(text_fr),
    _FRAME(EOL),
};
#endif

xim_externaldef
XimFrameRec im_aux_start_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _FRAME(BIT16),		/* input-context-ID */
    _FRAME(BIT32),		/* aux window class INDEX */
    _FRAME(POINTER),
    _PTR(string_fr),
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_aux_start_reply_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _FRAME(BIT16),		/* input-context-ID */
    _FRAME(BIT32),		/* aux window class INDEX */
    _FRAME(POINTER),
    _PTR(string_fr),
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_aux_draw_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _FRAME(BIT16),		/* input-context-ID */
    _FRAME(BIT32),		/* aux window class INDEX */
    _FRAME(POINTER),
    _PTR(string_fr),
    _BYTE_COUNTER(BIT32, 1),	/* byte length of integer value list */
    _FRAME(ITER),		/* integer value list */
    _FRAME(BIT32),
    _BYTE_COUNTER(BIT32, 1),	/* byte length of string value list */
    _FRAME(ITER),		/* integer value list */
    _FRAME(POINTER),
    _PTR(string_fr),
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_aux_draw_reply_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _FRAME(BIT16),		/* input-context-ID */
    _FRAME(BIT32),		/* aux window class INDEX */
    _FRAME(POINTER),
    _PTR(string_fr),
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_aux_done_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _FRAME(BIT16),		/* input-context-ID */
    _FRAME(BIT32),		/* aux window class INDEX */
    _FRAME(POINTER),
    _PTR(string_fr),
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_aux_done_reply_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _FRAME(BIT16),		/* input-context-ID */
    _FRAME(BIT32),		/* aux window class INDEX */
    _FRAME(POINTER),
    _PTR(string_fr),
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_aux_setvalues_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _FRAME(BIT16),		/* input-context-ID */
    _FRAME(BIT32),		/* aux window class INDEX */
    _FRAME(POINTER),
    _PTR(string_fr),
    _BYTE_COUNTER(BIT32, 1),	/* byte length of integer value list */
    _FRAME(ITER),		/* integer value list */
    _FRAME(BIT32),
    _BYTE_COUNTER(BIT32, 1),	/* byte length of string value list */
    _FRAME(ITER),		/* integer value list */
    _FRAME(POINTER),
    _PTR(string_fr),
    _FRAME(EOL),
};

xim_externaldef
XimFrameRec im_aux_setvalues_reply_fr[] = {
    _FRAME(BIT16),		/* input-method-ID */
    _FRAME(BIT16),		/* input-context-ID */
    _FRAME(BIT32),		/* aux window class INDEX */
    _FRAME(POINTER),
    _PTR(string_fr),
    _FRAME(EOL),
};
