/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2011 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "ibuffer.h"


#include "ierror.h"


template<class T>
iBuffer<T>::iBuffer()
{
	this->mLen = 100;
	this->mArr = new T[this->mLen]; IERROR_ASSERT(this->mArr);
}


template<class T>
iBuffer<T>::~iBuffer()
{
	delete [] this->mArr;
}


template<class T>
void iBuffer<T>::Reset(bool fill0)
{
	delete [] this->mArr;
	this->mLen = 100;
	this->mArr = new T[this->mLen]; IERROR_ASSERT(this->mArr);
	if(fill0) memset(this->mArr,0,this->mLen*sizeof(T));
}


template<class T>
T& iBuffer<T>::operator[](int i)
{
	if(i >= this->mLen) this->Extend(i+1);
	return this->mArr[(i<0)?0:i];
}


template<class T>
void iBuffer<T>::Fill(const T* ptr, int size)
{
	int i;

	if(size > this->mLen) this->Extend(size);
	for(i=0; i<size; i++) this->mArr[i] = ptr[i]; // we cannot use memcpy here because = is not necessarily a simple memory copy
}


template<class T>
void iBuffer<T>::Extend(int s)
{
	if(s > this->mLen)
	{
		delete [] this->mArr;
		this->mLen = s;
		mArr = new T[this->mLen]; IERROR_ASSERT(mArr);
	}
}

