/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iggwidgetreloading.h"


#include "icontrolmodule.h"
#include "idata.h"
#include "idatareader.h"
#include "ishell.h"
#include "iviewmodule.h"

#include "iggmainwindow.h"

#include "iggparameter.h"
using namespace iggParameter;


iggWidgetReloadingRadioBox::iggWidgetReloadingRadioBox(const iDataInfo &info, const iString &title, const iObjectKey &key, iggFrame *parent) : iggWidgetKeyRadioBox(1,title,0,key,parent), mInfo(info)
{
}


void iggWidgetReloadingRadioBox::OnInt1Body(int i)
{
	iggWidgetKeyRadioBox::OnInt1Body(i);
	this->GetMainWindow()->RequestReloadData(mInfo);
}


iggWidgetReloadingSlider::iggWidgetReloadingSlider(const iDataInfo &info, int min, int max, int numdig, const iString &title, const iObjectKey &key, iggFrame *parent, int index) : iggWidgetKeyIntSlider(min,max,numdig,title,key,_RenderModeNoRender,parent,index), mInfo(info)
{
}


void iggWidgetReloadingSlider::OnVoid1Body()
{
	iggWidgetKeyIntSlider::OnVoid1Body();
	this->GetMainWindow()->RequestReloadData(mInfo);
}


iggWidgetReloadingCheckBox::iggWidgetReloadingCheckBox(const iDataInfo &info, const iString &title, const iObjectKey &key, iggFrame *parent) : iggWidgetKeyCheckBox(title,key,parent), mInfo(info)
{
}


void iggWidgetReloadingCheckBox::OnVoid1Body()
{
	iggWidgetKeyCheckBox::OnVoid1Body();
	this->GetMainWindow()->RequestReloadData(mInfo);
}


iggWidgetReloadingPushButton::iggWidgetReloadingPushButton(const iString &title, iggFrame *parent) : iggWidgetSimpleButton(title,parent)
{
	iString tt = "Click this button to reload the current data set.";
	this->SetBaloonHelp(tt);
}


void iggWidgetReloadingPushButton::UpdateWidgetBody()
{
	this->Enable(this->GetMainWindow()->GetReloadDataInfo().Count()>0 && this->GetShell()->GetControlModule()->GetViewModule()->GetReader()->IsThereData(this->GetMainWindow()->GetReloadDataInfo()));
}


void iggWidgetReloadingPushButton::Execute()
{
	this->GetMainWindow()->ReloadData();
	this->Enable(false);
}

