/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef IHISTOGRAM_H
#define IHISTOGRAM_H


#include "ipiecewisefunction.h"
#include "iviewmodulecomponent.h"


#include "iposition.h"

class iHistogramMaker;


class iHistogram : public iPiecewiseFunction, protected iViewModuleComponent
{
	
	friend class iHistogramMaker;

public:
	
	static iHistogram* New(iViewModule *vm, iHistogramMaker *parent = 0);
	
	int GetStretch() const { return mStretch; }

	float GetMinValue() const { return mValMin; }
	float GetMaxValue() const { return mValMax; }

	long GetMinCellIndex() const { return mCellMin; }
	long GetMaxCellIndex() const { return mCellMax; }

	const iPosition& GetMinCellPosition() const { return mPosMin; }
	const iPosition& GetMaxCellPosition() const { return mPosMax; }
	
	void Copy(const iHistogram *h);

protected:
	
	iHistogramMaker *mParent;

	float mValMin, mValMax;
	int mStretch;

	//
	//  Properties of the Min and Max cells
	//
	long mCellMin, mCellMax;
	iPosition mPosMin, mPosMax;

private:

	iHistogram(iViewModule *vm, iHistogramMaker *parent);
	virtual ~iHistogram();
};

#endif

