/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


//
//  Single-type data consumer
//
#ifndef IDATACONSUMER_H
#define IDATACONSUMER_H


#include "iviewmodulecomponent.h"


#include "iarray.h"
#include "iparameter.h"
#include "istring.h"

class iDataHandler;
class iDataInfo;
class iDataType;
class iView;

class vtkDataSet;


//
//  Helper class for providing requests
//
class iDataSyncRequest
{

	friend class iDataConsumer;

public:

	~iDataSyncRequest();

	int Var() const { return mVar; }
	const iDataInfo& Data() const { return *mDataInfoPointer; }

private:

	iDataSyncRequest();
	void Set(int var, const iDataInfo &info);

	int mVar;
	iDataInfo* mDataInfoPointer;
};


class iDataConsumer : public iViewModuleComponent
{

	friend class iDataHandler;
	friend class iViewModule;

public:

	static void SetGlobalOptimizationMode(int mode);
	static int GetGlobalOptimizationMode(){ return mModeGlobal; }

	void SetOptimizationMode(int mode);
	int GetOptimizationMode() const;

	inline bool IsOptimizedForSpeed() const { return this->GetOptimizationMode() == iParameter::_DataConsumerOptimizeForSpeed; }
	inline bool IsOptimizedForMemory() const { return this->GetOptimizationMode() == iParameter::_DataConsumerOptimizeForMemory; }
	inline bool IsOptimizedForQuality() const { return this->GetOptimizationMode() == iParameter::_DataConsumerOptimizeForQuality; }

	virtual const iDataType& GetDataType() const;
	virtual bool IsDataPresent() const;
	bool IsUsingData(const iDataInfo &info, bool onlyprimary) const;

	void AddSecondaryDataType(const iDataType &type);

	inline const iDataInfo& GetPrimaryDataInfo() const { return *mPrimaryDataInfo; }
	inline const iDataInfo& GetSecondaryDataInfo() const { return *mSecondaryDataInfo; }

	virtual void SyncWithData(const iDataSyncRequest &r);
	const iDataSyncRequest& RequestAll();
	const iDataSyncRequest& RequestPrimary();
	const iDataSyncRequest& Request(int var);
	static const iDataSyncRequest& Request(const iDataInfo &info, int var = -1);

protected:

    iDataConsumer(iViewModule *vm, const iDataType &type);
    virtual ~iDataConsumer();

	virtual vtkDataSet* GetData() const;

	void RegisterDataHandler(iDataHandler *c);
	void UnRegisterDataHandler(iDataHandler *c);

	virtual void SyncWithDataBody(const iDataSyncRequest &r) = 0;

	iDataInfo *mPrimaryDataInfo, *mSecondaryDataInfo;
	iDataSyncRequest mRequest;

	iPointerArray<iDataHandler> mDataHandlers;

	static int mModeGlobal;
	int mModeLocal;
	bool mOverrideGlobal;
};


#endif // IDATACONSUMER_H

