/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef IEXTENSIONFACTORY_H
#define IEXTENSIONFACTORY_H


class iAnimator;
class iAnimatorScript;
class iControlModule;
class iDataReader;
class iExtendableObject;
class iObject;
class iObjectType;
class iPicker;
class iRenderTool;
class iString;
class iViewModule;
class iViewObject;
class iViewObjectParent;


class iExtensionFactory
{
	
	friend class iAnimatorScript;
	friend class iControlModule;
	friend class iDataExplorer;
	friend class iDataReader;
	friend class iExtendableObject;
	friend class iParticlesViewSubject;
	friend class iPicker;
	friend class iRenderTool;
	friend class iViewModule;
	friend class iViewObject;

protected:
		
	static iAnimatorScript*		CreateAnimatorScript(iAnimator *animator);
	static iRenderTool*			CreateRenderTool(iViewModule *vm);
	static iViewObject*			CreateViewObject(iViewObjectParent *parent);

	//
	//  Extensions for extendable objects
	//
	static void					InstallExtensions(iControlModule *cm);
	static void					InstallExtensions(iDataReader *dr);
	static void					InstallExtensions(iPicker *picker);
	static void					InstallExtensions(iViewModule *vm);
};

#endif // IEXTENSIONFACTORY_H
