/* You may find the license in the LICENSE file */
 var FileHandling = {
 	get _uniqueList() {
 		let u = {};
 		for (d in Tree.selected) {
 			if (d.is(COMPLETE)) {
 				let f = d.destinationFile;
 				if (SYSTEMSLASH == "\\") {
 					f = f.toLowerCase();	
 				}
 				if (!(f in u)) {
 					u[f] = null;
 					yield d;
 				}
 			}
 		}
 	},
	openFolder: function() {
		for (d in Tree.selected) {
			try {
				if (new FileFactory(d.destinationPath).exists()) {
					OpenExternal.reveal(d.destinationFile);
				}
			}
			catch (ex) {
				Debug.log('reveal', ex);
			}
		}
	},
	openFile: function() {
		var cur = Tree.current;
		if (cur && cur.is(COMPLETE)) {
			try {
				OpenExternal.launch(cur.destinationFile);
			}
			catch (ex) {
				Debug.log('launch', ex);
			}
		}
	},
	deleteFile: function() {
		var list = [];
		
		for (d in this._uniqueList) {
			var file = new FileFactory(d.destinationFile);
			if (file.exists()) {
				list.push(d);
			}
		}
		var msg = '';
		if (list.length < 25) {
			msg = _('deletetexts');
			for each (let d in list) {
				msg += "\n" + (new FileFactory(d.destinationFile)).leafName;
			}
		}
		else {
			msg = _('deletetextl', [list.length]);
		}
		if (list.length && Prompts.confirm(window, _('deletetitle'), msg, _('delete'), Prompts.CANCEL, null, 1)) {
			return;
		}
		for each (let d in list) {
			try {
				var file = new FileFactory(d.destinationFile);
				if (file.exists()) {
					file.remove(false);
				}
			}
			catch (ex) {
				// no-op
			}
		}
		Tree.remove(null, true);
	}
};