/*
 * This file is part of hyantes.
 *
 * hyantes is free software; you can redistribute it and/or modify
 * it under the terms of the CeCILL-C License
 *
 * You should have received a copy of the CeCILL-C License
 * along with this program.  If not, see <http://www.cecill.info/licences>.
 */

#include "module.h"
#include "engine.h"
#include "hs_compat.h"

#include "tbb/task_scheduler_init.h"
#include "tbb/parallel_for.h"
#include "tbb/blocked_range.h"
#include "tbb/atomic.h"

tbb::atomic < unsigned long >count;
unsigned long get_status()
{
    return (unsigned long) count;
}
/*
 * functor
 */
struct MyMakePot
{
    hs_potential_t *my_data;
    const struct make_pot_param *my_param;
  public:
    void operator() (const tbb::blocked_range < size_t > &r) const
    {
        hs_potential_t *data = my_data;
        for(size_t i = r.begin(); i != r.end(); ++i)
            make_pot(data + i, my_param);
        count += (r.end() - r.begin());
    }

    MyMakePot(hs_potential_t data[],
       const struct make_pot_param *param):my_data(data), my_param(param)
    {
        count = 0;
    }
};

/*
 * module entry point
 */
int make_all_pot(hs_potential_t * iter, int nb_iter,
   const struct make_pot_param *param)
{
    tbb::task_scheduler_init init;
    MyMakePot mmpot(iter, param);
    tbb::parallel_for(tbb::blocked_range < size_t > (0, nb_iter, 10),
       mmpot);
    return 1;
}

int init_module(va_list * ap)
{
    return 0;
}
