/*
 * This file is part of hyantes.
 *
 * hyantes is free software; you can redistribute it and/or modify
 * it under the terms of the CeCILL-C License
 *
 * You should have received a copy of the CeCILL-C License
 * along with this program.  If not, see <http://www.cecill.info/licences>.
 */

#include "module.h"
#include "engine.h"

static unsigned long count = 0;

int init_module(va_list * ap)
{
    return ap == NULL ? 1 : 0;
}


int make_all_pot(hs_potential_t * iter, size_t nb_iter,
   const struct make_pot_param *param)
{
    size_t i;
    /* compute pot */
    for(i = 0; i < nb_iter; ++i)
    {
        make_pot(iter, param);
        ++iter;
        ++count;
    }
    return 1;
}

unsigned long get_status()
{
    return count;
}
