/** 
* @file hyantes.h
* @brief declaration of exported hyantes functions
* include this file to get definitions from the hyantes library
* @author serge guelton
* @date 2008-02-13
*/

/*
 * This file is part of hyantes.
 *
 * hyantes is free software; you can redistribute it and/or modify
 * it under the terms of the CeCILL-C License
 *
 * You should have received a copy of the CeCILL-C License
 * along with this program.  If not, see <http://www.cecill.info/licences>.
 */

#ifndef _HYANTES_HS_SMOOTHING_H
#define _HYANTES_HS_SMOOTHING_H

#include <math.h>
#include <stdio.h>

#ifndef M_PI
#define M_PI (double)(3.1415926535897932384626433832795029L)
#endif

/** 
* @brief structure containing the coordinates of an area
* all coordinate are given in degree
* which means that
* -90 <= latitude <= 90
*  and
* -180 <= longitude <= +180
*/
typedef struct hs_coord
{
    double mLat; /**< minimum latitude*/
    double mLon; /**< minimum longitude*/
    double MLat; /**< maximum latitude*/
    double MLon; /**< maximum longitude*/
} hs_coord_t;

/** 
* @brief structure containing the coordinate of a potential
* all coordiante are given in radians
* which means that
* -90 <= latitude <= +90
*  and
* -180 <= longitude <= +180
*/
typedef struct hs_potential
{
    double lat; /**< latitude of the potential*/
    double lon; /**< longitude of the potential*/
    double pot; /**< value of the potential*/
} hs_potential_t;

/*@null@*/ hs_potential_t *hs_smoothing(
   int resoLat,
   int resoLon,
   const char *function_name,
   double function_param, hs_coord_t visu, FILE * pFileReference);

/*@observer@*/ const char **hs_list_smoothing(size_t * sz);

unsigned long hs_status();


#endif
