#include "hx_types.h"
#include "cmd.h"
#include <stdlib.h>

#define ecmd(name) extern int cmd_##name (int argc, char *const *argv, const char *str)

typedef int (*cmd_fn_t)(int, char *const *, const char *);
typedef cmd_fn_t t;

ecmd(cd);
ecmd(clear);
ecmd(close);
ecmd(chat);
ecmd(chats);
ecmd(colourz);
ecmd(dirchar);
ecmd(front);
ecmd(get);
ecmd(hl);
ecmd(icon);
ecmd(info);
ecmd(invite);
ecmd(join);
ecmd(kick);
ecmd(lcd);
ecmd(leave);
ecmd(load);
ecmd(lpwd);
ecmd(ls);
ecmd(me);
ecmd(mkdir);
ecmd(msg);
ecmd(news);
ecmd(nick);
ecmd(post);
ecmd(put);
ecmd(pwd);
ecmd(pwho);
ecmd(rm);
ecmd(save);
ecmd(server);
ecmd(subject);
ecmd(tasks);
ecmd(tracker);
ecmd(type);
ecmd(who);
ecmd(xfers);
ecmd(xfkill);

#ifdef __HAL__
ecmd(hal);
#else
int
cmd_hal (void)
{
	return -1;
}
#endif

int cmd_commands (void);
int cmd_main (void);
int cmd_quit (void);
int cmd_version (void);

extern void hx_exit (int) __attribute__((__noreturn__));

int
cmd_quit (void)
{
	hx_exit(0);
}

#include "screen.h"

int
cmd_commands (void)
{
	register int i;

	for (i = 1; builtin_commands[i].main; i++)
		curscr_printf("\n%s", builtin_commands[i].name);

	return i;
}

extern char const *hx_version_string;

int
cmd_version (void)
{
#ifdef __GNUC__
	curscr_printf("\n%s (gcc version %s)", hx_version_string, __VERSION__);
#else
	curscr_printf("\n%s", hx_version_string);
#endif

	return 0;
}

struct cmd builtin_commands[] = {
	{0,		0,		0},
	{"cd",		cmd_cd,		""},
	{"chat",	cmd_chat,	""},
	{"chats",	cmd_chats,	""},
	{"clear",	cmd_clear,	""},
	{"close",	cmd_close,	""},
	{"colourz",	cmd_colourz,	""},
	{"commands", (t)cmd_commands,	""},
	{"dirchar",	cmd_dirchar,	""},
	{"get",		cmd_get,	""},
	{"hal",      (t)cmd_hal,	""},
	{"hl",		cmd_hl,		""},
	{"icon",	cmd_icon,	""},
	{"info",	cmd_info,	""},
	{"invite",	cmd_invite,	""},
	{"join",	cmd_join,	""},
	{"kick",	cmd_kick,	""},
	{"lcd",		cmd_lcd,	""},
	{"leave",	cmd_leave,	""},
	{"load",	cmd_load,	""},
	{"lpwd",	cmd_lpwd,	""},
	{"ls",		cmd_ls,		""},
	{"me",		cmd_me,		""},
	{"mkdir",	cmd_mkdir,	""},
	{"msg",		cmd_msg,	""},
	{"news",	cmd_news,	""},
	{"nick",	cmd_nick,	""},
	{"post",	cmd_post,	""},
	{"put",		cmd_put,	""},
	{"pwd",		cmd_pwd,	""},
	{"pwho",	cmd_pwho,	""},
	{"quit",     (t)cmd_quit,	""},
	{"rm",		cmd_rm,		""},
	{"save",	cmd_save,	""},
	{"server",	cmd_server,	""},
	{"subject",	cmd_subject,	""},
	{"tasks",	cmd_tasks,	""},
	{"tracker",	cmd_tracker,	""},
	{"type",	cmd_type,	""},
	{"version",  (t)cmd_version,	""},
	{"who",		cmd_who,	""},
	{"xfers",	cmd_xfers,	""},
	{"xfkill",	cmd_xfkill,	""},
	{"\0",		0,		0}
};

char lookup_table[26] = {
	0,	/* 'a' */
	0,	/* 'b' */
	1,	/* 'c' */
	8,	/* 'd' */
	0,	/* 'e' */
	0,	/* 'f' */
	9,	/* 'g' */
	10,	/* 'h' */
	12,	/* 'i' */
	15,	/* 'j' */
	16,	/* 'k' */
	17,	/* 'l' */
	22,	/* 'm' */
	25,	/* 'n' */
	0,	/* 'o' */
	27,	/* 'p' */
	31,	/* 'q' */
	32,	/* 'r' */
	33,	/* 's' */
	36,	/* 't' */
	0,	/* 'u' */
	39,	/* 'v' */
	40,	/* 'w' */
	41,	/* 'x' */
	0,	/* 'y' */
	0	/* 'z' */
};

#include <string.h>

struct cmd *
cmd_lookup (char *name)
{
	register unsigned int i, len;
	register struct cmd *cp;

	if (*name < 'a' || *name > 'z' || !(i = (int)lookup_table[(*name - 'a')]))
		return 0;

	len = strlen(name);
	cp = 0;
	for (; *builtin_commands[i].name == *name; i++)
		if (!strncmp(name, builtin_commands[i].name, len)) {
			if (!cp) {
				cp = &(builtin_commands[i]);
				if (strlen(cp->name) == len)
					break;
			} else
				return (struct cmd *)-1;
		}

	return cp;
}
