/* This file is part of MemMXtest
 * Copyright (C) 1999, 2000  J.A. Bezemer
 * This program is licensed under the GNU General Public License,
 * see the top-level README file for details.
 */

/* Here is where the test sequence is programmed */

#include "defines.h"
#include "mtest.h"
#include "tests.h"


/* Prototypes for functions at the end of this file */
void stdtestseq (void (testfunc) (pattern64, pattern64));
void pr_stdtestseq (void (testfunc) (unsigned long passes),
		    unsigned long passes);
void testseq_marchwom (void);


/* The main test sequence */
void
testseq (void)
{
  /* begin/end addr, cache mode and refresh rate have been set already */

  switch (testset)
    {
      /* case 0x0:  Default set = set 0x1000 (see below) */

    case 0x100:		/* March tests starting from 0x100 */
      stdtestseq (march_a);
      break;
    case 0x101:
      stdtestseq (march_b);
      break;
    case 0x102:
      stdtestseq (march_cminus);
      break;
    case 0x103:
      stdtestseq (march_cminus_r);
      break;
    case 0x104:
      stdtestseq (march_g);
      break;
    case 0x105:
      stdtestseq (march_la);
      break;
    case 0x106:
      stdtestseq (march_lr);
      break;
    case 0x107:
      stdtestseq (march_matsplus);
      break;
    case 0x108:
      stdtestseq (march_matsplusplus);
      break;
    case 0x109:
      stdtestseq (march_pmovi);
      break;
    case 0x10A:
      stdtestseq (march_pmovi_r);
      break;
    case 0x10B:
      stdtestseq (march_scan);
      break;
    case 0x10C:
      stdtestseq (march_u);
      break;
    case 0x10D:
      stdtestseq (march_u_r);
      break;
    case 0x10E:
      stdtestseq (march_ud);
      break;
    case 0x10F:
      stdtestseq (march_y);
      break;
    case 0x110:
      testseq_marchwom ();
      break;

    case 0x200:		/* Pseudo-random starting from 0x200 */
      pr_stdtestseq (prmarch_prscan, 5);
      break;
    case 0x201:
      pr_stdtestseq (prmarch_prcminus, 5);
      break;
    case 0x202:
      pr_stdtestseq (prmarch_prpmovi, 5);
      break;

    case 0x0:			/* Default set */
    case 0x1000:		/* "Do them all" */
      stdtestseq (march_a);
      stdtestseq (march_b);
      stdtestseq (march_cminus);
      stdtestseq (march_cminus_r);
      stdtestseq (march_g);
      stdtestseq (march_la);
      stdtestseq (march_lr);
      stdtestseq (march_matsplus);
      stdtestseq (march_matsplusplus);
      stdtestseq (march_pmovi);
      stdtestseq (march_pmovi_r);
      stdtestseq (march_scan);
      stdtestseq (march_u);
      stdtestseq (march_u_r);
      stdtestseq (march_ud);
      stdtestseq (march_y);
      testseq_marchwom ();
      break;

    case 0x1001:		/* "Lots of Pseudo-Random" */
      pr_stdtestseq (prmarch_prscan, 10);
      pr_stdtestseq (prmarch_prcminus, 10);
      pr_stdtestseq (prmarch_prpmovi, 10);
      break;

    default:
      cprint ("Error: unimplemented testset specified.");
      println ();
    }
}


/* This is a "template" procedure that runs the function that is passed
   as parameter.
   Example: stdtestseq(march_a);
   Note: can also be defined as
   void stdtestseq (void (*testfunc) (pattern64, pattern64))
   (               note --^   and --v )
   and/or be called like stdtestseq(&march_a);
   but it will still do the right thing (gcc doesn't know either ;-)
 */
void
stdtestseq (void (testfunc) (pattern64, pattern64))
{
  pattern64 p, n;
  unsigned long i;

  patterncount = 0;
  while (pattern_generate64 (&p, &n))
    {
      for (i = 0; i < MAX_ADRBITMAPS; i++)

	if ((adrbitmap_list[i])[0] != 0xFF)
	  {
	    cprint ("AddressBitMap: ");
	    hprint (i);
	    println ();

	    adrbitmap_p = &(adrbitmap_list[i]);

	    testfunc (p, n);

	    input_buffer ();	/* Save pressed keys for later use */
	    patterncount++;
	  }
    }
}


void
pr_stdtestseq (void (testfunc) (unsigned long passes), unsigned long passes)
{
  unsigned long i;

  for (i = 0; i < MAX_ADRBITMAPS; i++)

    if ((adrbitmap_list[i])[0] != 0xFF)
      {
	cprint ("AddressBitMap: ");
	hprint (i);
	println ();

	adrbitmap_p = &(adrbitmap_list[i]);

	testfunc (passes);

	input_buffer ();	/* Save pressed keys for later use */
      }
}


void
testseq_marchwom (void)
{
  pattern64 p, n;

  printtestname_0 ("March WOM");

  if ((adrbitmap_list[0])[0] == 0xFF || (adrbitmap_list[1])[0] == 0xFF)
    {
      cprint ("Error: not executed due to unsuitable address maps");
      println ();
      return;
    }

  adrbitmap_p = &(adrbitmap_list[0]);	/* fast-x */
  p = 0x0000000000000000ULL;
  n = 0xFFFFFFFFFFFFFFFFULL;
  marchel_up_wp_wn_rn (p, n);
  input_buffer ();		/* Save pressed keys for later use */

  adrbitmap_p = &(adrbitmap_list[1]);	/* fast-y */
  p = 0xFFFFFFFFFFFFFFFFULL;
  n = 0x0000000000000000ULL;
  marchel_dn_rp_wn_rn (p, n);
  input_buffer ();

  adrbitmap_p = &(adrbitmap_list[0]);	/* fast-x */
  p = 0x0000000000000000ULL;
  n = 0x7777777777777777ULL;
  marchel_dn_rp_wn_rn (p, n);
  input_buffer ();

  adrbitmap_p = &(adrbitmap_list[1]);	/* fast-y */
  p = 0x7777777777777777ULL;
  n = 0x8888888888888888ULL;
  marchel_up_rp_wn_rn (p, n);
  input_buffer ();

  adrbitmap_p = &(adrbitmap_list[0]);	/* fast-x */
  p = 0x8888888888888888ULL;
  n = 0x0000000000000000ULL;
  marchel_up_rp_wn (p, n);
  input_buffer ();

  adrbitmap_p = &(adrbitmap_list[0]);	/* fast-x */
  p = 0xBBBBBBBBBBBBBBBBULL;
  n = 0xBBBBBBBBBBBBBBBBULL;
  marchel_dn_wp_rn (p, n);
  input_buffer ();

  adrbitmap_p = &(adrbitmap_list[1]);	/* fast-y */
  p = 0xBBBBBBBBBBBBBBBBULL;
  n = 0x4444444444444444ULL;
  marchel_dn_rp_wn_rn (p, n);
  input_buffer ();

  adrbitmap_p = &(adrbitmap_list[0]);	/* fast-x */
  p = 0x4444444444444444ULL;
  n = 0x0000000000000000ULL;
  marchel_up_rp_wn (p, n);
  input_buffer ();

  adrbitmap_p = &(adrbitmap_list[1]);	/* fast-y */
  p = 0xDDDDDDDDDDDDDDDDULL;
  n = 0xDDDDDDDDDDDDDDDDULL;
  marchel_up_wp_rn (p, n);
  input_buffer ();

  adrbitmap_p = &(adrbitmap_list[0]);	/* fast-x */
  p = 0xDDDDDDDDDDDDDDDDULL;
  n = 0x2222222222222222ULL;
  marchel_dn_rp_wn_rn (p, n);
  input_buffer ();

  adrbitmap_p = &(adrbitmap_list[0]);	/* fast-x */
  p = 0x2222222222222222ULL;
  n = 0x0000000000000000ULL;
  marchel_up_rp_wn (p, n);
  input_buffer ();

  adrbitmap_p = &(adrbitmap_list[1]);	/* fast-y */
  p = 0xEEEEEEEEEEEEEEEEULL;
  n = 0xEEEEEEEEEEEEEEEEULL;
  marchel_dn_wp_rn (p, n);
  input_buffer ();

  adrbitmap_p = &(adrbitmap_list[1]);	/* fast-y */
  p = 0xEEEEEEEEEEEEEEEEULL;
  n = 0x1111111111111111ULL;
  marchel_up_rp_wn_rn (p, n);
  input_buffer ();

  adrbitmap_p = &(adrbitmap_list[1]);	/* fast-y */
  p = 0x1111111111111111ULL;
  marchel_dn_rp (p);
  input_buffer ();
}
