/* This file is part of MemMXtest
 * Copyright (C) 1999, 2000  J.A. Bezemer
 * This program is licensed under the GNU General Public License,
 * see the top-level README file for details.
 */

/* The pattern generators */

#include "mtest.h"

/* Prototypes for generators in this file */
int pattern_counting64 (pattern64 * p, pattern64 * n);
int pattern_counting64i (pattern64 * p, pattern64 * n);
int pattern_walking164 (pattern64 * p, pattern64 * n);
int pattern_16walking1s64 (pattern64 * p, pattern64 * n);
int pattern_oneszeros64 (pattern64 * p, pattern64 * n);
int pattern_oneszeros64i (pattern64 * p, pattern64 * n);


/* Fill `p' and `n' with pattern number `patterncount' from the
   `patterngen' set. Return 1 if okay, 0 if no more patterns.
   Note that `n' doesn't necessarily have to be the inverse of `p'. */
int
pattern_generate64 (pattern64 * p, pattern64 * n)
{

/* Note: you _can_ change `patterngen' during testing, but that will
   override the interactively specified one. */
  switch (patterngen)
    {
    case 0x0:
      return pattern_counting64 (p, n);
    case 0x1:
      return pattern_counting64i (p, n);
    case 0x2:
      return pattern_walking164 (p, n);
    case 0x3:
      return pattern_16walking1s64 (p, n);
    case 0x4:
      return pattern_oneszeros64 (p, n);
    case 0x5:
      return pattern_oneszeros64i (p, n);

    default:
      cprint ("Error: unimplemented pattern generator specified.");
      println ();
      return 0;
    }
}

/* Counting pattern, as in Stout */
int
pattern_counting64 (pattern64 * p, pattern64 * n)
{
  pattern64 counting[] =
  {
    0x0000000000000000ULL,
    0x5555555555555555ULL,
    0x3333333333333333ULL,
    0x0F0F0F0F0F0F0F0FULL,
    0x00FF00FF00FF00FFULL,
    0x0000FFFF0000FFFFULL,
    0x00000000FFFFFFFFULL
  };

  if (patterncount < 7)
    {
      *p = counting[patterncount];
      *n = ~(*p);
      return 1;
    }
  else
    return 0;
}

/* Counting pattern, as in Stout, including inverted patterns */
int
pattern_counting64i (pattern64 * p, pattern64 * n)
{
  pattern64 counting[] =
  {
    0x0000000000000000ULL,
    0x5555555555555555ULL,
    0x3333333333333333ULL,
    0x0F0F0F0F0F0F0F0FULL,
    0x00FF00FF00FF00FFULL,
    0x0000FFFF0000FFFFULL,
    0x00000000FFFFFFFFULL
  };

  if (patterncount < 7)
    {
      *p = counting[patterncount];
      *n = ~(*p);
      return 1;
    }
  else if (patterncount < 14)
    {
      *n = counting[patterncount - 7];
      *p = ~(*n);
      return 1;
    }
  else
    return 0;
}

/* One 1 walks through all 64 bits */
int
pattern_walking164 (pattern64 * p, pattern64 * n)
{
  if (patterncount < 130)
    {
      *p = 1 << (patterncount / 2);
      if ((patterncount % 2) == 1)
	*p = ~(*p);
      *n = ~(*p);
      return 1;
    }
  else
    return 0;
}

/* One 1 per nibble walks through 4 bits */
int
pattern_16walking1s64 (pattern64 * p, pattern64 * n)
{
  if (patterncount < 10)
    {
      *p = 0x1111111111111111ULL << (patterncount / 2);
      if ((patterncount / 2) == 4)
	*p = 0;
      if ((patterncount % 2) == 1)
	*p = ~(*p);
      *n = ~(*p);
      return 1;
    }
  else
    return 0;
}

/* Only 1's and only 0's */
int
pattern_oneszeros64 (pattern64 * p, pattern64 * n)
{
  if (patterncount == 0)
    {
      *p = 0xFFFFFFFFFFFFFFFFULL;
      *n = 0x0000000000000000ULL;
      return 1;
    }
  else
    return 0;
}

/* Only 1's and only 0's, and inverted */
int
pattern_oneszeros64i (pattern64 * p, pattern64 * n)
{
  if (patterncount == 0)
    {
      *p = 0xFFFFFFFFFFFFFFFFULL;
      *n = 0x0000000000000000ULL;
      return 1;
    }
  else if (patterncount == 1)
    {
      *p = 0x0000000000000000ULL;
      *n = 0xFFFFFFFFFFFFFFFFULL;
      return 1;
    }
  else
    return 0;
}
