/* This file is part of MemMXtest
 * Copyright (C) 1999, 2000  J.A. Bezemer
 * This program is licensed under the GNU General Public License,
 * see the top-level README file for details.
 */

#include "defines.h"
#include "mtest.h"
#include "tests.h"

void
marchel_up_template (char *testname, void (mltest) (void), char argno,
		     pattern64 pattern_p, pattern64 pattern_n)
/* argno is either 1 or 2; for 1 argument leave pattern_n = 0 */
{
  /* Print test name and parameters */
  if (argno == 1)
    printsubtestname64_1 (testname, pattern_p);
  else
    printsubtestname64_2 (testname, pattern_p, pattern_n);

  /* Clear the error space */
  clear_sub_errors ();
  lasterror_p -= 6;		/* last error should still fit in */

  /* Compute update_adr code */
  pre_adrcode_len = prepare_update_adr_up (pretest_adrbitmap,
				PRETEST_START, PRETEST_END, 0, pre_adrcode);
  real_adrcode_len = prepare_update_adr_up (*adrbitmap_p,
				     startadr, endadr - 8, 1, real_adrcode);

  /* Set parameters */
  *((pattern64 *) (param + P_POSPATTERNU)) = pattern_p;
  *((pattern64 *) (param + P_NEGPATTERNU)) = pattern_n;		/* may be 0 */
  param[P_UPADRCODE] = (unsigned long) &real_adrcode;
  param[P_UPADRLEN] = real_adrcode_len;
  param[P_UPADRCODEPRE] = (unsigned long) &pre_adrcode;
  param[P_UPADRLENPRE] = pre_adrcode_len;
  param[P_CONDITION] = P_CONDITION_UP;
  param[P_CACHEMODE] = sub_cachemode;

  /* Call machine language routine */
  mltest ();

  /* Update the total error count */
  total_error_count += sub_errorno;

  /* Show errors */
  showerrors64 (testname);
}


void
marchel_dn_template (char *testname, void (mltest) (void), char argno,
		     pattern64 pattern_p, pattern64 pattern_n)
/* argno is either 1 or 2; for 1 argument leave pattern_n = 0 */
{
  /* Print test name and parameters */
  if (argno == 1)
    printsubtestname64_1 (testname, pattern_p);
  else
    printsubtestname64_2 (testname, pattern_p, pattern_n);

  /* Clear the error space */
  clear_sub_errors ();
  lasterror_p -= 6;		/* last error should still fit in */

  /* Compute update_adr code */
  pre_adrcode_len = prepare_update_adr_dn (pretest_adrbitmap,
				PRETEST_END, PRETEST_START, 0, pre_adrcode);
  real_adrcode_len = prepare_update_adr_dn (*adrbitmap_p,
				     endadr - 8, startadr, 1, real_adrcode);

  /* Set parameters */
  *((pattern64 *) (param + P_POSPATTERNU)) = pattern_p;
  *((pattern64 *) (param + P_NEGPATTERNU)) = pattern_n;		/* may be 0 */
  param[P_UPADRCODE] = (unsigned long) &real_adrcode;
  param[P_UPADRLEN] = real_adrcode_len;
  param[P_UPADRCODEPRE] = (unsigned long) &pre_adrcode;
  param[P_UPADRLENPRE] = pre_adrcode_len;
  param[P_CONDITION] = P_CONDITION_DOWN;
  param[P_CACHEMODE] = sub_cachemode;

  /* Call machine language routine */
  mltest ();

  /* Update the total error count */
  total_error_count += sub_errorno;

  /* Show errors */
  showerrors64 (testname);
}
