/*
//
// option.h
//
// Program options and setting
//
// Copyright (c) 1995-96 Jim Nelson.  Permission to distribute
// granted by the author.  No warranties are made on the fitness of this
// source code.
//
*/

#ifndef OPTION_H
#define OPTION_H

/* option names */
extern const char *OPT_N_IMGXY;
extern const char *OPT_N_QUIET;
extern const char *OPT_N_DEPEND;
extern const char *OPT_N_PRECIOUS;
extern const char *OPT_N_CONDENSE;
extern const char *OPT_N_USAGE;
extern const char *OPT_N_SET_DELIM;
extern const char *OPT_N_KEEP_TEMP;

/* pre-defined option values (for boolean options) */
extern const char *OPT_V_TRUE;
extern const char *OPT_V_FALSE;

/* OPT_N_SET_DELIM values */
extern const char *OPT_V_DELIM_HTML;
extern const char *OPT_V_DELIM_SQUARE;
extern const char *OPT_V_DELIM_CURLY;

/* option callback ... name will be one of OPT_N_* and value OPT_V_* */
/* can be used to take additional actions when an option is set */
/* name will be NULL if an error occured parsing text, and value will */
/* be the text that caused the problem */
typedef BOOL (*OPTION_CALLBACK)(const char *name, const char *value,
    ulong userParam);

/* these are used at the beginning and end of program execution, respectively */
BOOL InitializeGlobalOption(OPTION_CALLBACK optionCallback, ulong userParam);
void DestroyGlobalOption(void);

/* these are used at the beginning and end of local context, that is, as a new */
/* file is being created and completed */
BOOL InitializeLocalOption(void);
void DestroyLocalOption(void);

/* parse text or markups for options ... global setting dictates whether to */
/* use current context or default to global option settings */
BOOL ParseTextOption(const char *string, OPTION_CALLBACK optionCallback,
    ulong userParam);
BOOL ParseMarkupOption(const HTML_MARKUP *htmlMarkup, OPTION_CALLBACK optionCallback,
    ulong userParam);

/* retrieve option information ... IsOptionEnabled() doesnt mean much for */
/* options that require values rather than boolean states, and for boolean */
/* options, GetOption() returns OPT_V_TRUE or OPT_V_FALSE */
BOOL IsOptionEnabled(const char *option);
const char *GetOptionValue(const char *option);

/* macros for quick lookups */
#define IMGXY               (IsOptionEnabled(OPT_N_IMGXY))
#define QUIET               (IsOptionEnabled(OPT_N_QUIET))
#define DEPEND              (IsOptionEnabled(OPT_N_DEPEND))
#define PRECIOUS            (IsOptionEnabled(OPT_N_PRECIOUS))
#define CONDENSE            (IsOptionEnabled(OPT_N_CONDENSE))
#define USAGE               (IsOptionEnabled(OPT_N_USAGE))
#define KEEPTEMP            (IsOptionEnabled(OPT_N_KEEP_TEMP))

#endif

