/*****************************************************************************\
  global_types.h : global types, enums, and #defines for APDK

  Copyright (c) 1996 - 2002, Hewlett-Packard Co.
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:
  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
  3. Neither the name of Hewlett-Packard nor the names of its
     contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
  NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
  TO, PATENT INFRINGEMENT; PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
  OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
  ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
\*****************************************************************************/


/*! \addtogroup globals
Definitions for global variables, types, and #defines
@{
*/

//
// Definitions and structures needed by applications
//
// This file does not include C++ class definitions etc. so it can
// be included by calling C or C++ source files

#ifndef APDK_GLOBAL_TYPES_H
#define APDK_GLOBAL_TYPES_H

#include "models.h"
#include "modes.h"

// ** Defines

#ifndef NOTHROW
    #define NOTHROW (nothrow)
#endif

#ifndef NULL
    #define NULL 0
#endif

#ifndef BOOL
    typedef int BOOL;
    #define TRUE 1
    #define FALSE 0
#endif

typedef unsigned char BYTE;

typedef unsigned short WORD;

typedef unsigned long DWORD;

#ifndef LOWORD
    #define LOWORD(l)   ((WORD) (l))
#endif

#ifndef HIWORD
    #define HIWORD(l)   ((WORD) (((DWORD) (l) >> 16) & 0xFFFF))
#endif

#ifndef ABS
    #define ABS(x)      ( ((x)<0) ? -(x) : (x) )
#endif

#ifdef BLACK_PEN
    #undef BLACK_PEN
#endif

#ifdef NO_ERROR
    #undef NO_ERROR
#endif

APDK_BEGIN_NAMESPACE


//! \internal For use in connection with PCL media-type command.  Values are PCL codes.
enum MediaType
{
    mediaAuto = -1,
    mediaPlain = 0,
    mediaBond = 0,
    mediaSpecial = 2,
    mediaGlossy = 3,
    mediaTransparency = 4,
	mediaHighresPhoto = 5		// used by vip printers for 2400 mode
};


//! \internal For use in connection with PCL media-size command. Values are PCL codes.
enum MediaSize
{
    sizeUSLetter = 2,
    sizeUSLegal = 3,
    sizeA4 = 26,
    sizeNum10Env = 81,
    sizePhoto = 74,             // 4x6 Index Card / Photo paper
    sizeA6 = 73,				// used to be 24, full-bleed support is for 73 only. Is same size though
    sizeB4 = 46,
    sizeB5 = 45,
    sizeOUFUKU = 72,
    sizeHAGAKI = 71,
    sizeA3 = 27,
    sizeA5 = 25
};


//! \internal For use in connection with PCL media-source command.  Values are PCL codes.
enum MediaSource
{
    sourceTray1 = 1,
//  sourceTray2 = 4,        // no second tray in current supported list
    sourceManual = 2,
    sourceManualEnv = 3,
	sourceTrayAuto = 7
};


//! \internal For use in connection with PCL quality-mode command.  Values are PCL codes.
enum Quality
{
    qualityDraft = -1,
    qualityNormal = 0,
    qualityPresentation = 1
};

enum FontIndex
{
    COURIER_INDEX = 1,
    CGTIMES_INDEX = 2,
    LETTERGOTHIC_INDEX = 3,
    UNIVERS_INDEX = 4
};

const int MAX_CHAR_SET = 5;

const int MAX_POINTSIZES = 5;

const int MAXCOLORDEPTH = 3;

const int MAXCOLORPLANES = 6;   // current max anticipated, 6 for 690 photopen

const int MAXCOLORROWS = 2;     // multiple of high-to-low for mixed-resolution cases

// ** JOB related structures/enums

//! Possible pen combinations
enum PEN_TYPE
{
    BLACK_PEN,                  //!< Only BLACK pen in the printer
    COLOR_PEN,                  //!< Only COLOR pen in the printer
    BOTH_PENS,                  //!< BLACK & COLOR pens in printer
    MDL_PEN,                    //!< Photo pen in the printer
    MDL_BOTH,                   //!< COLOR and Photo pen in printer
    MDL_AND_BLACK_PENS,         //!< BLACK and Photo pen in printer
    MDL_BLACK_AND_COLOR_PENS,   //!< BLACK, COLOR and Photo pen in printer
    // if more pen or pen combos are added then add them here and point MAX_PEN_TYPE to the last one
    NO_PEN,                     //!< No pens in the printer
    DUMMY_PEN,                  //!< Not a possible value - used for initialization
    MAX_PEN_TYPE = MDL_BLACK_AND_COLOR_PENS   //!< base 0, ending with MDL_BOTH (NOT NO_PEN)
};
//const int MAX_PEN_TYPE = 4;


//! Supported Paper sizes
/*
The PAPER_SIZE enum is directly supported by PSM in PrintContext
do not change the order of the PAPER_SIZE enum.  The static array in
PrintContext depends on this order.  Any changes to this enum may require
changes to the PSM array.
*/
typedef enum              // typedef'ed for C interface
{
    UNSUPPORTED_SIZE =-1,           //!< Not supported paper size (also used as mandatory flag)
    LETTER = 0,                     //!< 8.5 x 11 in.
    A4 = 1,                         //!< 210 x 297 mm.
    LEGAL = 2,                      //!< 8.25 x 14 in.
    PHOTO_SIZE = 3,                 //!< 4x6 Photo with tear-off tab
    A6 = 4,                         //!< 105 x 148 mm.
    CARD_4x6 = 5,                   //!< 4x6 photo/card without tear-off tab
    B4 = 6,                         //!< 250 x 353 mm.
    B5 = 7,                         //!< 176 x 250 mm.
    OUFUKU = 8,                     //!< 148 x 200 mm.
    OFUKU = 8,                      //!< Misspelled - here for backwards compatibility
    HAGAKI = 9,                     //!< 100 x 148 mm.
    A6_WITH_TEAR_OFF_TAB = 10,      //!< A6 with tear-off tab
#ifdef APDK_AUTODUPLEX
    A3 = 11,                        //!< 294 x 419.8 mm.
    A5 = 12,                        //!< 148 x 210 mm.
#endif
    MAX_PAPER_SIZE                  //!< Only for array size and loops
} PAPER_SIZE;


typedef enum            // typedef'ed for C interface
{
    CLEAN_PEN = 0
} PRINTER_FUNC;


// ** TEXT related structures/enums

//! Supported Text colors for device text
typedef enum           // typedef'ed for C interface
{
    WHITE_TEXT,
    CYAN_TEXT,
    MAGENTA_TEXT,
    BLUE_TEXT,
    YELLOW_TEXT,
    GREEN_TEXT,
    RED_TEXT,
    BLACK_TEXT
} TEXTCOLOR;


// currently only portrait fonts are supported
enum TEXTORIENT
{
    PORTRAIT,
    LANDSCAPE,
    BOTH
};

const int MAX_FONT_SIZES = 10;      // max # of fonts to be realized at one time


// ** I/O related stuff

const int TIMEOUTVAL = 500;         // in msec, ie 0.5 sec

typedef WORD PORTID;
typedef void * PORTHANDLE;

enum MODE1284
{
    COMPATIBILITY,
    NIBBLE,
    ECP
};


enum HALFTONING_ALGORITHM
{
    FED,
    MATRIX
};


//! Color modes for SelectPrintMode
typedef enum               // typedef'ed for C interface
{
    GREY_K,                 //!< Use the BLACK pen to print B&W only
    GREY_CMY,               //!< Use the COLOR pen to print grey scale
    COLOR,                  //!< Use the COLOR pen to print color
    MAX_COLORMODE
} COLORMODE;


//! Quality modes for SelectPrintMode
typedef enum                // typedef'ed for C interface
{
    QUALITY_NORMAL,         //!< Normal quality print mode (probably 300x300)
    QUALITY_DRAFT,          //!< Draft print mode - the same or faster then normal
    QUALITY_BEST,           //!< Probably slower and possible higher resolution
	QUALITY_HIGHRES_PHOTO,	//!< 1200 dpi - currently 9xxvip, linux only
    MAX_QUALITY_MODE
} QUALITY_MODE;


//! Media types for SelectPrintMode
typedef enum               // typedef'ed for C interface
{
    MEDIA_PLAIN,            //!< Plain paper
    MEDIA_PREMIUM,          //!< Premium paper - for use with 6xx series
    MEDIA_PHOTO,            //!< Photo paper - for use with photo quality printers
    MAX_MEDIATYPE
} MEDIATYPE;


//////////////////////////////////////////////////////////////////////////////////////
//  values of DRIVER_ERROR
// first of 2 hex digits indicates category

typedef enum                // typedef'ed for C interface
{

// general or system errors
    NO_ERROR             =  0x00,    //!< everything okay
    JOB_CANCELED         =  0x01,    //!< CANCEL chosen by user
    SYSTEM_ERROR         =  0x02,    //!< something bad that should not have happened
    ALLOCMEM_ERROR       =  0x03,    //!< failed to allocate memory
    NO_PRINTER_SELECTED  =  0x04,    //!< indicates improper calling sequence or unidi
    INDEX_OUT_OF_RANGE   =  0x05,    //!< what it says
    ILLEGAL_RESOLUTION   =  0x06,    //!< tried to set resolution at unacceptable value
    NULL_POINTER         =  0x07,    //!< supplied ptr was null

// build-related
// (items either absent from current build, or just bad index from client code)
    UNSUPPORTED_PRINTER  =  0x10,    //!< selected printer-type unsupported in build
    UNSUPPORTED_PEN      =  0x11,    //!< selected pen-type unsupported
    TEXT_UNSUPPORTED     =  0x12,    //!< no text allowed in current build, UsePageWidth is false
    GRAPHICS_UNSUPPORTED =  0x13,    //!< no graphics allowed in current build
    UNSUPPORTED_FONT     =  0x14,    //!< font selection failed
    ILLEGAL_COORDS       =  0x15,    //!< bad (x,y) passed to TextOut
    UNSUPPORTED_FUNCTION =  0x16,    //!< bad selection for PerformPrinterFunction
    BAD_INPUT_WIDTH      =  0x18,    //!< inputwidth is 0 and
    OUTPUTWIDTH_EXCEEDS_PAGEWIDTH = 0x19, //!< inputwidth exceeds printable width
    UNSUPPORTED_SCALING  =  0x1a,    //!< inputwidth exceeds outputwidth, can't shrink output

// I/O related
    IO_ERROR             =  0x20,    //!< I/O error communicating with printer
    BAD_DEVICE_ID        =  0x21,    //!< bad or garbled device id from printer
    CONTINUE_FROM_BLOCK  =  0x22,    //!< continue from blocked state for printers with no buttons

// WARNINGS
// convention is that values < 0 can be ignored (at user's peril)
    WARN_MODE_MISMATCH    =  -1,     //!< printmode selection incompatible with pen, tray, etc.
    WARN_DUPLEX           =  -2,     //!< duplexer installed; our driver can't use it
    WARN_LOW_INK_BOTH_PENS=  -3,     //!< sensor says pens below threshold
    WARN_LOW_INK_BLACK    =  -4,     //!< sensor says black pen below threshold
    WARN_LOW_INK_COLOR    =  -5,     //!< sensor says color pen below threshold
    WARN_FULL_BLEED_UNSUPPORTED = -6,//!< device does not support full-bleed printing
    WARN_FULL_BLEED_3SIDES = -7,     //!< full bleed on only 3 sides
    WARN_ILLEGAL_PAPERSIZE = -8,     //!< papersize illegal for given hardware
	ILLEGAL_PAPERSIZE      = -8
} DRIVER_ERROR; //DRIVER_ERROR


///////////////////////////////////////////////////////////////////////////////////////

// ** Printer Status return values


enum DISPLAY_STATUS
{    // used for DisplayPrinterStatus
    NODISPLAYSTATUS = -1,
    DISPLAY_PRINTING,
    DISPLAY_PRINTING_COMPLETE,
    DISPLAY_PRINTING_CANCELED,
    DISPLAY_OFFLINE,
    DISPLAY_BUSY,
    DISPLAY_OUT_OF_PAPER,
    DISPLAY_TOP_COVER_OPEN,
    DISPLAY_ERROR_TRAP,
    DISPLAY_NO_PRINTER_FOUND,
    DISPLAY_NO_PEN_DJ400,
    DISPLAY_NO_PEN_DJ600,
    DISPLAY_NO_COLOR_PEN,
    DISPLAY_NO_BLACK_PEN,
    DISPLAY_NO_PENS,
    DISPLAY_PHOTO_PEN_WARN,
    DISPLAY_PRINTER_NOT_SUPPORTED,
    DISPLAY_COMM_PROBLEM,
    DISPLAY_CANT_ID_PRINTER,
    DISPLAY_OUT_OF_PAPER_NEED_CONTINUE,
	DISPLAY_PAPER_JAMMED,
	DISPLAY_PHOTOTRAY_MISMATCH,

    // internal driver use only

    ACCEPT_DEFAULT,
    DISPLAY_PRINTCONTEXT_WARN,
    DISPLAY_PRINTMODE_WARN,
    DISPLAY_JOB_WARN
};


// ** move these to internal.h
// items from wtv_interp.h

const int NUMBER_PLANES = 3;

// must be #define instead of const int for C interface
#define NUMBER_RASTERS  3            // The number of Rasters to Buffer
//const int NUMBER_RASTERS = 3;

//
// ** move these to intenal.h

struct fOptSubSig
{
    float pi;
    const float *means;
};


struct fOptClassSig
{
    int nsubclasses;
    float variance;
    float inv_variance;
    float cnst;
    struct fOptSubSig *OptSubSig;
};


struct fOptSigSet
{
    int nbands;
    struct fOptClassSig *OptClassSig;
};


struct RESSYNSTRUCT
{
        int             Width;
        int             ScaleFactorMultiplier;
        int             ScaleFactorDivisor;
//      int             CallerAlloc;         // Who does the memory alloc.
        int             Remainder;           // For use in non integer scaling cases
        int             Repeat;              // When to send an extra output raster
        int             RastersinBuffer;     // # of currently buffered rasters
        unsigned char*  Bufferpt[NUMBER_RASTERS];
        int             BufferSize;
        unsigned char*  Buffer;
        struct fOptSigSet OS;
        struct fOptSubSig rsOptSubSigPtr1[45];
        struct fOptClassSig OCS;
        float **joint_means;
        float ***filter;
        float filterPtr1[45];
        float filterPtr2[45][9];
        float joint_meansPtr1[45];

};

#ifdef APDK_AUTODUPLEX
enum DUPLEXMODE
{
    DUPLEXMODE_NONE,
    DUPLEXMODE_TABLET,
    DUPLEXMODE_BOOK
};
#endif

APDK_END_NAMESPACE

/*! @} */ // end globals group (documentation)

#endif //APDK_GLOBAL_TYPES_H
