/*
 * Copyright 2003, 2004 Porchdog Software. All rights reserved.
 *
 *	Redistribution and use in source and binary forms, with or without modification,
 *	are permitted provided that the following conditions are met:
 *
 *		1. Redistributions of source code must retain the above copyright notice,
 *		   this list of conditions and the following disclaimer.   
 *		2. Redistributions in binary form must reproduce the above copyright notice,
 *		   this list of conditions and the following disclaimer in the documentation
 *		   and/or other materials provided with the distribution.
 *
 *	THIS SOFTWARE IS PROVIDED BY PORCHDOG SOFTWARE ``AS IS'' AND ANY
 *	EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *	WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *	IN NO EVENT SHALL THE HOWL PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 *	BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *	DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 *	OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 *	OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 *	OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *	The views and conclusions contained in the software and documentation are those
 *	of the authors and should not be interpreted as representing official policies,
 *	either expressed or implied, of Porchdog Software.
 *
 * 2005-1-14 - modified by Duane Maxwell/Linspire, Inc to generate XML for use in Lsongs
 */

#include <howl.h>
#include <stdio.h>
#include <signal.h>

static void outxmlb(const char *s,int len) {
	const char *p = s;
	while (len--) {
		char c = *p++;
		switch (c) {
			case '>': printf("&gt;"); break;
			case '<': printf("&lt;"); break;
			case '&': printf("&amp;"); break;
			case '\'': printf("&apos;"); break;
			case '"': printf("&quot;"); break;
			default: printf("%c",c); break;
		}
	}
}

static void outxmls(const char *s) {
	outxmlb(s,strlen(s));
}

static sw_result HOWL_API
my_service_reply(
				sw_discovery						discovery,
				sw_discovery_oid					id,
				sw_discovery_publish_status	status,
				sw_opaque							extra)
{
	static sw_string
	status_text[] =
	{
		"<started/>",
		"<stopped/>",
		"<namecollision/>",
		"<invalid/>"
	};

	printf("%s\n", status_text[status]);
	fflush(stdout);
	return SW_OKAY;
}

sw_discovery discovery = 0;

void quitHandler(int sig) {
	signal(sig,SIG_IGN);
	if (discovery) {
		printf("<exiting/>\n");
		sw_discovery_fina(discovery);
		discovery = 0;
	}
	exit(0);
}

#if defined(WIN32)
int __cdecl
#else
int
#endif
main(
	int		argc,
	char	**	argv)
{
	sw_text_record					text_record;
	sw_result						result;
	sw_discovery_publish_id	id;
	int								i;

	signal(SIGINT,quitHandler);
	signal(SIGHUP,quitHandler);
	
	if (sw_discovery_init(&discovery) != SW_OKAY)
	{
		printf("<mdnsnotavailable/>\n");
		fflush(stdout);
		return -1;
	}

	if (argc < 4)
	{
		fprintf(stderr, "usage: howlxml_publish <name> <type> <port> [service text 1]...[service text n]\n");
		return -1;
	}

	if (sw_text_record_init(&text_record) != SW_OKAY)
	{
		printf("<textrecordinitfailed/>\n");
		fflush(stdout);
		return -1;
	}

	for (i = 4; i < argc; i++)
	{
		if (sw_text_record_add_string(text_record, argv[i]) != SW_OKAY)
		{
			printf("<unabletoaddservicetext value='");
			outxmls(argv[i]);
			printf("'/>\n");
			fflush(stdout);
			return -1;
		}
	}

	//printf("%s %s %d\n", argv[1], argv[2], atoi(argv[3]));

	if ((result = sw_discovery_publish(discovery, 0, argv[1], argv[2], NULL, NULL, atoi(argv[3]), sw_text_record_bytes(text_record), sw_text_record_len(text_record), my_service_reply, NULL, &id)) != SW_OKAY)
	{
		printf("<publishfailed result='%d'/>\n", result);
		fflush(stdout);
		sw_text_record_fina(text_record);
		return -1;
	}

	sw_text_record_fina(text_record);

	sw_discovery_run(discovery);

	return 0;
}
