{- This module was generated from data in the Kate syntax
   highlighting file restructuredtext.xml, version 1.0, by Massimiliano Torromeo (massimiliano.torromeo@gmail.com) -}

module Text.Highlighting.Kate.Syntax.Restructuredtext
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)

-- | Full name of language.
syntaxName :: String
syntaxName = "Restructured Text"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.rst"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("Restructured Text","Normal")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  if length contexts >= 2
    then case context of
      ("Restructured Text","Normal") -> return ()
      ("Restructured Text","CodeBlock") -> return ()
      ("Restructured Text","Code") -> return ()
      ("Restructured Text","Directive") -> (popContext) >> pEndLine
      ("Restructured Text","Link") -> (popContext) >> pEndLine
      ("Restructured Text","URL") -> return ()
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)


regex_'5c'2a'5b'5e'2a_'5d'2e'2a'5cS'5c'2a = compileRegex True "\\*[^* ].*\\S\\*"
regex_'5c'2a'5c'2a'5cS'2e'2a'5cS'5c'2a'5c'2a = compileRegex True "\\*\\*\\S.*\\S\\*\\*"
regex_'60'60'5cS'2e'2a'5cS'60'60 = compileRegex True "``\\S.*\\S``"
regex_'5c'2e'5c'2e_ = compileRegex True "\\.\\. "
regex_'28'23'7b3'2c'7d'7c'5c'2a'7b3'2c'7d'7c'3d'7b3'2c'7d'7c'2d'7b3'2c'7d'7c'5c'5e'7b3'2c'7d'7c'22'7b3'2c'7d'7c'27'7b3'2c'7d'7c'7e'7b3'2c'7d'7c'60'7b3'2c'7d'7c'5c'2b'7b3'2c'7d'29'24 = compileRegex True "(#{3,}|\\*{3,}|={3,}|-{3,}|\\^{3,}|\"{3,}|'{3,}|~{3,}|`{3,}|\\+{3,})$"
regex_'5b'230'2d9'5d'5c'2e'5cs = compileRegex True "[#0-9]\\.\\s"
regex_'3a'3a'24 = compileRegex True "::$"
regex_'5cs = compileRegex True "\\s"
regex_'5cS = compileRegex True "\\S"
regex_'5cw'2b = compileRegex True "\\w+"
regex_'5b'5e'3e'5d'2b = compileRegex True "[^>]+"

parseRules ("Restructured Text","Normal") =
  (((pRegExpr regex_'5c'2a'5b'5e'2a_'5d'2e'2a'5cS'5c'2a >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'5c'2a'5c'2a'5cS'2e'2a'5cS'5c'2a'5c'2a >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'60'60'5cS'2e'2a'5cS'60'60 >>= withAttribute DataTypeTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5c'2e'5c'2e_ >>= withAttribute DecValTok) >>~ pushContext ("Restructured Text","Directive"))
   <|>
   ((pColumn 0 >> pRegExpr regex_'28'23'7b3'2c'7d'7c'5c'2a'7b3'2c'7d'7c'3d'7b3'2c'7d'7c'2d'7b3'2c'7d'7c'5c'5e'7b3'2c'7d'7c'22'7b3'2c'7d'7c'27'7b3'2c'7d'7c'7e'7b3'2c'7d'7c'60'7b3'2c'7d'7c'5c'2b'7b3'2c'7d'29'24 >>= withAttribute KeywordTok))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'5b'230'2d9'5d'5c'2e'5cs >>= withAttribute DecValTok))
   <|>
   ((pFirstNonSpace >> pAnyChar "*+-" >>= withAttribute FloatTok))
   <|>
   ((pDetectChar False '`' >>= withAttribute StringTok) >>~ pushContext ("Restructured Text","Link"))
   <|>
   ((pRegExpr regex_'3a'3a'24 >>= withAttribute DataTypeTok) >>~ pushContext ("Restructured Text","CodeBlock"))
   <|>
   (currentContext >>= \x -> guard (x == ("Restructured Text","Normal")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Restructured Text","CodeBlock") =
  (((pColumn 0 >> pRegExpr regex_'5cs >>= withAttribute DataTypeTok) >>~ pushContext ("Restructured Text","Code"))
   <|>
   (currentContext >>= \x -> guard (x == ("Restructured Text","CodeBlock")) >> pDefault >>= withAttribute DataTypeTok))

parseRules ("Restructured Text","Code") =
  (((pColumn 0 >> lookAhead (pRegExpr regex_'5cS) >> (popContext >> popContext) >> currentContext >>= parseRules))
   <|>
   (currentContext >>= \x -> guard (x == ("Restructured Text","Code")) >> pDefault >>= withAttribute DataTypeTok))

parseRules ("Restructured Text","Directive") =
  (((pRegExpr regex_'5cw'2b >>= withAttribute KeywordTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Restructured Text","Directive")) >> pDefault >>= withAttribute DecValTok))

parseRules ("Restructured Text","Link") =
  (((pDetectChar False '<' >>= withAttribute StringTok) >>~ pushContext ("Restructured Text","URL"))
   <|>
   ((pDetect2Chars False '`' '_' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Restructured Text","Link")) >> pDefault >>= withAttribute StringTok))

parseRules ("Restructured Text","URL") =
  (((pRegExpr regex_'5b'5e'3e'5d'2b >>= withAttribute StringTok))
   <|>
   ((pDetectChar False '>' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Restructured Text","URL")) >> pDefault >>= withAttribute StringTok))


parseRules x = parseRules ("Restructured Text","Normal") <|> fail ("Unknown context" ++ show x)
