/***************************************************************************
                          xslfocode.h  -  description
                             -------------------
    begin                : Do 11.12.2003
    copyright            : (C) 2003 by Andre Simon
    email                : andre.simon1@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef XSLFOGENERATOR_H
#define XSLFOGENERATOR_H


#include <string>
#include <sstream>
#include <iostream>
#include <fstream>

#include "codegenerator.h"
#include "version.h"

namespace highlight {

/**
   \brief This class generates XSL-FO.

   It contains information about the resulting document structure (document
   header and footer), the colour system, white space handling and text
   formatting attributes.

* @author Andre Simon
*/

class XslFoGenerator : public highlight::CodeGenerator
  {
  public:

   /** Constructor
     \param colourTheme Name of Colour theme to use
     \param fopCompatible Test if output should be compatible with Apache FOP 0.20.5
    */
    XslFoGenerator( const string &colourTheme,
                    bool fopCompatible=false);

    XslFoGenerator();

    ~XslFoGenerator();

   /** prints document header
       \param  title Title of the document
    */
    string getHeader(const string & title);

    /** Prints document footer*/
    string getFooter();

    /** Prints document body*/
    void printBody();

  private:
    bool fopOutput;
    ostringstream snl;
    string styleDefinition;

    /** \return escaped character*/
    virtual string maskCharacter(unsigned char );

    string getOpenTag(const ElementStyle &);

    /** \return custom line break sequence*/
    string getNewLine();

    string getMatchingOpenTag(unsigned int styleID);
    string getMatchingCloseTag(unsigned int styleID);
  };

}

#endif
