/*
 * Hexxagon board game.
 * Copyright (C) 2001 Erik Jonsson.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Email erik@nesqi.homeip.net
 * 
 */

#include "gtk-options.h"

#include <gtk/gtk.h>

int comp_level = 4;
int comp_timeout = 12;

GtkWidget *spinner_level;
GtkWidget *spinner_time;

GtkWidget *r1, *r2, *r3, *r4, *r5, *r6;

void options_ok_callback(GtkWidget *dialog)
{
	comp_level = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spinner_level));
	comp_timeout = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spinner_time));

	gtk_widget_destroy(GTK_WIDGET(dialog));
}

void options_radio_clicked(GtkToggleButton *togglebutton, gpointer user_data)
{
	comp_level = 0xFF & (int)user_data;        /* nice hack  =) */
	comp_timeout = 0xFF & ((int)user_data >> 8);
	
	if(gtk_toggle_button_get_active(togglebutton))
	{
		gtk_spin_button_set_value(GTK_SPIN_BUTTON(spinner_level), comp_level);
		gtk_spin_button_set_value(GTK_SPIN_BUTTON(spinner_time), comp_timeout);
	}
}

void options_spin_button_change(GtkWidget *tmp)
{
	int comp_level = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spinner_level));
	int comp_timeout = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spinner_time));

	if(comp_level == 2 && comp_timeout == 12)
		gtk_signal_emit_by_name(GTK_OBJECT(r1), "clicked");
	else if(comp_level == 3 && comp_timeout == 12)
		gtk_signal_emit_by_name(GTK_OBJECT(r2), "clicked");
	else if(comp_level == 4 && comp_timeout == 12)
		gtk_signal_emit_by_name(GTK_OBJECT(r3), "clicked");
	else if(comp_level == 5 && comp_timeout == 30)
		gtk_signal_emit_by_name(GTK_OBJECT(r4), "clicked");
	else if(comp_level == 6 && comp_timeout == 30)
		gtk_signal_emit_by_name(GTK_OBJECT(r5), "clicked");
	else
 		gtk_signal_emit_by_name(GTK_OBJECT(r6), "clicked");
}

void options_dialog()
{
	GtkWidget *options;

	options = gtk_dialog_new();
	gtk_window_set_modal(GTK_WINDOW(options), true);
	gtk_container_border_width(GTK_CONTAINER(options), 5);

	/* options area */
	GtkWidget *options_frame_std = gtk_frame_new("Difficulty");
	GtkWidget *options_frame_custom = gtk_frame_new("Levels / Timings");

	GtkWidget *hbox = gtk_hbox_new(false, 2);
	gtk_container_add(GTK_CONTAINER(hbox), options_frame_std);
	gtk_container_add(GTK_CONTAINER(hbox), options_frame_custom);
	gtk_container_add(GTK_CONTAINER(GTK_DIALOG(options)->vbox), hbox);
	
	/* Standard levels */

	/* Create a radio button with a GtkEntry widget */
    r1 = gtk_radio_button_new_with_label(0, " Very easy ");
    r2 = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(r1), " Easy ");
    r3 = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(r2), " Normal ");
    r4 = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(r3), " Difficult ");
    r5 = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(r4), " Very difficult ");
    r6 = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(r4), " Custom ");

	if(comp_level == 2 && comp_timeout == 12)
		gtk_signal_emit_by_name(GTK_OBJECT(r1), "clicked");
	else if(comp_level == 3 && comp_timeout == 12)
		gtk_signal_emit_by_name(GTK_OBJECT(r2), "clicked");
	else if(comp_level == 4 && comp_timeout == 12)
		gtk_signal_emit_by_name(GTK_OBJECT(r3), "clicked");
	else if(comp_level == 5 && comp_timeout == 30)
		gtk_signal_emit_by_name(GTK_OBJECT(r4), "clicked");
	else if(comp_level == 6 && comp_timeout == 30)
		gtk_signal_emit_by_name(GTK_OBJECT(r5), "clicked");
	else
 		gtk_signal_emit_by_name(GTK_OBJECT(r6), "clicked");
		
	gtk_signal_connect(GTK_OBJECT(r1), "toggled", GTK_SIGNAL_FUNC(options_radio_clicked), 
					   gpointer (2 + (12 << 8)));
	gtk_signal_connect(GTK_OBJECT(r2), "toggled", GTK_SIGNAL_FUNC(options_radio_clicked), 
					   gpointer (3 + (12 << 8)));
	gtk_signal_connect(GTK_OBJECT(r3), "toggled", GTK_SIGNAL_FUNC(options_radio_clicked), 
					   gpointer (4 + (12 << 8)));
	gtk_signal_connect(GTK_OBJECT(r4), "toggled", GTK_SIGNAL_FUNC(options_radio_clicked), 
					   gpointer (5 + (30 << 8)));
	gtk_signal_connect(GTK_OBJECT(r5), "toggled", GTK_SIGNAL_FUNC(options_radio_clicked), 
					   gpointer (6 + (30 << 8)));

	GtkWidget *vbox_levels = gtk_vbox_new(false, 0);
    gtk_box_pack_start(GTK_BOX(vbox_levels), r1, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(vbox_levels), r2, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(vbox_levels), r3, TRUE, TRUE, 2);
	gtk_box_pack_start(GTK_BOX(vbox_levels), r4, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(vbox_levels), r5, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(vbox_levels), r6, TRUE, TRUE, 2);
	gtk_container_add(GTK_CONTAINER(options_frame_std), vbox_levels);

	/* Custom */
    GtkAdjustment *adj_level = (GtkAdjustment *) gtk_adjustment_new(4.0, 1.0, 9.0, 1.0, 1.0, 1.0);
    GtkAdjustment *adj_time  = (GtkAdjustment *) gtk_adjustment_new(12.0, 1.0, 120.0, 1.0, 1.0, 1.0);
    spinner_level = gtk_spin_button_new(adj_level, 1.0, 0);
    spinner_time  = gtk_spin_button_new(adj_time, 1.0, 0);

	gtk_signal_connect_object(GTK_OBJECT(spinner_level), "changed",
							  GTK_SIGNAL_FUNC(options_spin_button_change), GTK_OBJECT(spinner_level));
	gtk_signal_connect_object(GTK_OBJECT(spinner_time), "changed",
							  GTK_SIGNAL_FUNC(options_spin_button_change), GTK_OBJECT(spinner_level));

	GtkWidget *vbox = gtk_vbox_new(false, 0);

	GtkWidget *hbox_level = gtk_hbox_new(false, 4);
	GtkWidget *label_level = gtk_label_new("Search depth (moves):");
    gtk_container_add(GTK_CONTAINER(hbox_level), label_level);
    gtk_container_add(GTK_CONTAINER(hbox_level), spinner_level);
	gtk_container_border_width(GTK_CONTAINER(hbox_level), 5);

	GtkWidget *hbox_time = gtk_hbox_new(false, 4);
	GtkWidget *label_time = gtk_label_new("Search time (seconds):");
    gtk_container_add(GTK_CONTAINER(hbox_time), label_time);
    gtk_container_add(GTK_CONTAINER(hbox_time), spinner_time);
	gtk_container_border_width(GTK_CONTAINER(hbox_time), 5);

    gtk_container_add(GTK_CONTAINER(vbox), hbox_level);
    gtk_container_add(GTK_CONTAINER(vbox), hbox_time);
    gtk_container_add(GTK_CONTAINER(options_frame_custom), vbox);

	gtk_spin_button_set_value(GTK_SPIN_BUTTON(spinner_level), comp_level);
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(spinner_time), comp_timeout);

	/* action area */
	GtkWidget *options_ok = gtk_button_new_with_label(" OK ");
	GtkWidget *options_cancel = gtk_button_new_with_label(" Cancel ");

	gtk_container_add(GTK_CONTAINER(GTK_DIALOG(options)->action_area), options_ok);
	gtk_container_add(GTK_CONTAINER(GTK_DIALOG(options)->action_area), options_cancel);

	gtk_signal_connect_object(GTK_OBJECT(options_cancel), "clicked",
							  GTK_SIGNAL_FUNC(gtk_widget_destroy), 
							  GTK_OBJECT(options));

	gtk_signal_connect_object(GTK_OBJECT(options_ok), "clicked",
							  GTK_SIGNAL_FUNC(options_ok_callback), 
							  GTK_OBJECT(options));

	gtk_widget_show_all(options);
}

