/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: rtcpmisc.h,v 1.1.1.1.38.1 2004/07/19 21:04:16 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

class ASMRuleBook;

///////////////////////////////////////////////////////////////////////////////
//  Class to calculate RTCP interval 
//
class CRTCPInterval
{
public:
    CRTCPInterval();
    CRTCPInterval(UINT32	ulSessionBW);
    ~CRTCPInterval();
    
    double	GetRTCPInterval (double rtcp_bw, INT32 nMembers = 1, INT32 nSenders = 0);

    void	UpdateAvgRTCPSize(UINT32 ulPktSize)
		{
		    m_avg_rtcp_size = (1.0/16.0) * ulPktSize + (15.0/16.0) * m_avg_rtcp_size;
		}

    // access func's
    BOOL	IsInitial() const { return m_bInitial; }
    double	GetRTCPBW() const { return m_rtcp_bw; }
    UINT32	GetLastRTCPTime() const { return m_ulLastRTCPTime; }
    UINT32	GetNextRTCPTime() const { return m_ulNextRTCPTime; }
    UINT32	GetLastNumMembers() const { return m_ulLastNumMembers; }
    UINT32	GetCurNumMembers() const { return m_ulCurNumMembers; }
    UINT32	GetNumSenders() const { return m_ulCurNumSenders; }


    void	SetInitial(BOOL b) 
		{
		    m_bInitial = b;
		}
    void	SetNextRTCPTime(UINT32 ulNextTime) 
		{
		    m_ulNextRTCPTime = ulNextTime;
		}
    void	SetLastNumMembers(UINT32 ulLastNumMembers)
		{
		    m_ulLastNumMembers = ulLastNumMembers;		        
		}
    void	SetCurNumMembers(UINT32 ulCurNumMembers)
		{
		    m_ulCurNumMembers = ulCurNumMembers; 
		}
    void	SetNumSenders(UINT32 ulNumSenders)
		{
		    m_ulCurNumSenders = ulNumSenders;
		}   
    void	SetLastRTCPTime(UINT32 ulLastTime)
		{
		    m_ulLastRTCPTime = ulLastTime;
		}
    void	SetAvgRtcpSize(UINT32 ulSize)
		{
		    // if it's 0, don't set it
		    if (ulSize)
		    {
			m_avg_rtcp_size = ulSize;
		    }
		}
private:
    UINT32	m_ulLastRTCPTime;
    UINT32	m_ulNextRTCPTime;
    UINT32	m_ulLastNumMembers;
    UINT32	m_ulCurNumMembers;
    UINT32	m_ulCurNumSenders;
    BOOL	m_bInitial;
    BOOL	m_bWeSent;
    
    double	m_rtcp_bw;
    double	m_avg_rtcp_size;
};

///////////////////////////////////////////////////////////////////////////////
//  Class for SDES
//
class CSDES
{
public:
    CSDES();
    
    CSDES(REF(IHXBuffer*) pCName, 
    	  REF(IHXBuffer*) pName, 
    	  REF(IHXBuffer*) pTool, 
    	  REF(IHXBuffer*) pEmail);
    
    ~CSDES();

    HX_RESULT	MakeSDES(REF(RTCPPacket) pktSDES, UINT32 ulSrcID);
private:
    IHXBuffer*		    m_pCName;
    IHXBuffer*		    m_pName;
    IHXBuffer*		    m_pTool;
    IHXBuffer*		    m_pEmail;
};


/*
 * functions
 */
HX_RESULT GetThresholdInfo  (REF(ASMRuleBook) rules, 
			     float* pThreshold, 
			     REF(UINT32) ulNumThreshold);
 
