/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: ogg_page_reader.h,v 1.1.2.4 2004/11/24 18:02:52 acolwell Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */
#ifndef OGG_PAGE_READER_H
#define OGG_PAGE_READER_H

#include "hxcom.h"
#include "hxfiles.h"

#include "ogg/ogg.h"

class IHXOggPageReaderResponse : public IUnknown
{
public:
    /*
     *  IUnknown methods
     */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, void** ppvObj) PURE;

    STDMETHOD_(ULONG32,AddRef) (THIS) PURE;

    STDMETHOD_(ULONG32,Release) (THIS) PURE;
    
    /*
     * IHXOggPageReaderResponse methods
     */
    STDMETHOD(PageReaderInitDone) (THIS_ HX_RESULT status) PURE;
    STDMETHOD(ReadNextPageDone) (THIS_ HX_RESULT status,
                                 ULONG32 ulFileOffset,
                                 UINT32 ulPageSize,
                                 ogg_page* pPage) PURE;
};

class COggPageReader : public IHXFileResponse,
                       public IHXFileStatResponse
{
public:
    COggPageReader();

    HX_RESULT Init(IHXOggPageReaderResponse* pResponse,
                   IHXFileObject* pFileObject);
    HX_RESULT Seek(ULONG32 ulFileOffset);
    HX_RESULT ReadNextPage();

    HX_RESULT CurrentPosition(REF(ULONG32) ulPos) const;
    BOOL IsSeekable() const;
    ULONG32 FileSize() const;
    HX_RESULT Close();

    /*
     *  IUnknown methods
     */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, void** ppvObj);

    STDMETHOD_(ULONG32,AddRef) (THIS);

    STDMETHOD_(ULONG32,Release) (THIS);

    /*
     *  IHXFileResponse methods
     */
    STDMETHOD(InitDone) (THIS_ HX_RESULT status) ;

    STDMETHOD(CloseDone) (THIS_ HX_RESULT status);
    STDMETHOD(ReadDone) (THIS_ HX_RESULT status, IHXBuffer* pBuffer);
    STDMETHOD(WriteDone) (THIS_ HX_RESULT status);
    STDMETHOD(SeekDone) (THIS_ HX_RESULT status);

    /*
     *  IHXFileStat methods
     */

    STDMETHOD(StatDone)(THIS_
                        HX_RESULT status,
                        UINT32 ulSize,
                        UINT32 ulCreationTime,
                        UINT32 ulAccessTime,
                        UINT32 ulModificationTime,
                        UINT32 ulMode);

private:
    typedef enum {rsStart = 0,
                  rsInitPending,
                  rsStatPending,
                  rsReady,
                  rsSeekPending,
                  rsSeekDuringPending,
                  rsReadPending,
                  rsDispatchReadPageDone,
                  rsReadDuringDispatch} ReaderState;

    ~COggPageReader();

    void ChangeState(ReaderState newState);

    HX_RESULT DoReadNextPage(BOOL bEOF);

    HX_RESULT DoSeek(ULONG32 ulFileOffset);
    HX_RESULT DoRead();

    HX_RESULT DispatchPage(HX_RESULT status,
                           ULONG32 ulFileOffset, UINT32 ulPageSize, 
                           ogg_page* pOg);

    ULONG32 m_lRefCount;
    ReaderState m_state;
    IHXOggPageReaderResponse* m_pResponse;
    IHXFileObject* m_pFile;
    IHXFileStat* m_pStat;
    BOOL m_bSeekable;
    UINT32 m_ulFileSize;
    ULONG32 m_ulPendingSeekOffset;

    ULONG32 m_ulCurrentFileOffset;
    ULONG32 m_ulFileObjectOffset;
    BOOL m_bEndOfFile;

    ogg_sync_state* m_pOy;
};
#endif /* OGG_PAGE_READER_H */
