@REM File Name: hdf5build.bat
@REM This batch file is used to build HDF5 Libraries and Tools.
@REM There are 4 options for this batch file:
@REM   1. hdf5build                -- Build HDF5 tools and c library
@REM   2. hdf5build enablecpp      -- Build HDF5 tools and c/c++ library
@REM   3. hdf5build enablefortran  -- Build HDF5 tools and c/fortran library
@REM   4. hdf5build enableall      -- Build HDF5 tools and c/c++/fortran library
@REM By Xuan Bai
@REM Created: Aug. 16, 2004
@REM Last Updated: Oct. 6, 2004

@ECHO OFF
if %1.==. GOTO BUILDC
if "%1"=="/?" GOTO HELP
if %1==enablecpp GOTO BUILDCPP
if %1==enablefortran GOTO BUILDF90
if %1==enableall GOTO BUILDALL
GOTO WRONG

:BUILDC
type nul > build_results.txt
echo ***************************************************************************** >> build_results.txt
echo                         Build H5Tinit.exe >> build_results.txt
echo ***************************************************************************** >> build_results.txt

cd misc\typegen\h5tinit
msdev h5tinit.dsp  /make "h5tinit - Win32 Debug" /Rebuild /out ..\..\..\h5tinit.log
cd ..\..\..\
more h5tinit.log >> build_results.txt
del h5tinit.log

echo ***************************************************************************** >> build_results.txt
echo                         Build HDF5 C Library and Tools >> build_results.txt
echo ***************************************************************************** >> build_results.txt

cd src
h5tinit.exe > h5tinit.c

cd ..\proj\all
msdev all.dsw /make "all - ALL" /Rebuild /out ..\..\all.log
cd ..\..
more all.log >> build_results.txt
del all.log
GOTO END

:BUILDCPP
type nul > build_results.txt
echo ***************************************************************************** >> build_results.txt
echo                         Build H5Tinit.exe >> build_results.txt
echo ***************************************************************************** >> build_results.txt

cd misc\typegen\h5tinit
msdev h5tinit.dsp  /make "h5tinit - Win32 Debug" /Rebuild /out ..\..\..\h5tinit.log
cd ..\..\..\
more h5tinit.log >> build_results.txt
del h5tinit.log

echo ***************************************************************************** >> build_results.txt
echo                         Build HDF5 C/C++ Libraries and Tools >> build_results.txt
echo ***************************************************************************** >> build_results.txt

cd src
h5tinit.exe > h5tinit.c

cd ..\proj\all
msdev all.dsw /make "testhdf5_cppdll - ALL" "testhdf5_cpp - ALL" "dsets_cppdll - ALL" "dsets_cpp - ALL" "all - ALL" /Rebuild /out ..\..\all.log
cd ..\..
more all.log >> build_results.txt
del all.log
GOTO END

:BUILDF90
type nul > build_results.txt
echo ***************************************************************************** >> build_results.txt
echo                         Build H5Tinit.exe >> build_results.txt
echo ***************************************************************************** >> build_results.txt

cd misc\typegen\h5tinit
msdev h5tinit.dsp  /make "h5tinit - Win32 Debug" /Rebuild /out ..\..\..\h5tinit.log
cd ..\..\..\
more h5tinit.log >> build_results.txt
del h5tinit.log

echo ***************************************************************************** >> build_results.txt
echo                         Build HDF5 C/Fortran Libraries and Tools >> build_results.txt
echo ***************************************************************************** >> build_results.txt

cd src
h5tinit.exe > h5tinit.c

cd ..\proj\all
msdev all.dsw /make "testhdf5_fortrandll - ALL" "testhdf5_fortran - ALL" "flush2_fortrandll - ALL" "flush2_fortran - ALL" "flush1_fortrandll - ALL" "flush1_fortran - ALL" "all - ALL" /Rebuild /out ..\..\all.log
cd ..\..
more all.log >> build_results.txt
del all.log
GOTO END

:BUILDALL
type nul > build_results.txt
echo ***************************************************************************** >> build_results.txt
echo                         Build H5Tinit.exe >> build_results.txt
echo ***************************************************************************** >> build_results.txt

cd misc\typegen\h5tinit
msdev h5tinit.dsp  /make "h5tinit - Win32 Debug" /Rebuild /out ..\..\..\h5tinit.log
cd ..\..\..\
more h5tinit.log >> build_results.txt
del h5tinit.log

echo ***************************************************************************** >> build_results.txt
echo                         Build HDF5 C/C++/Fortran Libraries and Tools >> build_results.txt
echo ***************************************************************************** >> build_results.txt

cd src
h5tinit.exe > h5tinit.c

cd ..\proj\all
msdev all.dsw /make "testhdf5_fortrandll - ALL" "testhdf5_fortran - ALL" "flush2_fortrandll - ALL" "flush2_fortran - ALL" "flush1_fortrandll - ALL" "flush1_fortran - ALL" "testhdf5_cppdll - ALL" "testhdf5_cpp - ALL" "dsets_cppdll - ALL" "dsets_cpp - ALL" "all - ALL" /Rebuild /out ..\..\all.log
cd ..\..
more all.log >> build_results.txt
del all.log
GOTO END

:WRONG
echo The syntax of the command is incorrect.
echo.

:HELP
echo Builds HDF5 Libraries and Tools.
echo.
echo hdf5build [OPTION]
echo.
echo Please use one of the following options!
echo.
echo    hdf5build                   Build HDF5 C Library and Tools
echo    hdf5build enablecpp         Build HDF5 C/C++ Libraries and Tools
echo    hdf5build enablefortran     Build HDF5 C/Fortran Libraries and Tools
echo    hdf5build enableall         Build HDF5 C/C++/Fortran Libraries and Tools
echo    hdf5build /?                Help information

:END