/*
 * happydigger - program for cataloging archaeological finds
 * Copyright (C) 2004, 2005 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include <string.h>
#include "callbacks.h"
#include "support.h"
#include "preferences.h"

extern GtkWidget *window;
extern gboolean im1, im2;
extern statestype state;

/* FILE SELECTION DIALOG */
gboolean
on_fileselection_delete_event (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	gtk_widget_set_sensitive (window, 1);
	return FALSE;
}

void
on_fileselection_ok_button_clicked (GtkButton *button, gpointer user_data)
{
	gchar* filename;
	GtkWidget *fileselection, *entry;

	fileselection = gtk_widget_get_toplevel(GTK_WIDGET(button));
	filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER(fileselection));
	if (filename)
	{
		if (im1)
			entry = lookup_widget (window, "image1entry");
		else
			entry = lookup_widget (window, "image2entry");
		gtk_entry_set_text (GTK_ENTRY(entry), filename);
		g_free (filename);
	}
	gtk_widget_set_sensitive (window, 1);
	gtk_widget_destroy(fileselection);
}

void
on_fileselection_cancel_button_clicked (GtkButton *button, gpointer user_data)
{
	gtk_widget_set_sensitive (window, 1);
	gtk_widget_destroy(gtk_widget_get_toplevel(GTK_WIDGET(button)));
}
