.\"                                      Hey, EMACS: -*- nroff -*-
.\" First parameter, NAME, should be all caps
.\" Second parameter, SECTION, should be 1-8, maybe w/ subsection
.\" other parameters are allowed: see man(7), man(1)
.TH HANZIM 1n "March 12, 2002"
.\" Please adjust this date whenever revising the manpage.
.\"
.\" Some roff macros, for reference:
.\" .nh        disable hyphenation
.\" .hy        enable hyphenation
.\" .ad l      left justify
.\" .ad b      justify to both left and right margins
.\" .nf        disable filling
.\" .fi        enable filling
.\" .br        insert line break
.\" .sp <n>    insert n+1 empty lines
.\" for manpage-specific macros, see man(7)
.SH NAME
hanzim \- Hanzi Master
.SH SYNOPSIS
.B hanzim
.RI [ options ] ...
.SH DESCRIPTION

\fBhanzim\fP is a combination Chinese character learning aid and interactive
dictionary.

This manual page briefly documents the
.B hanzim
command.  Expanded documentation may be found in "hanzim.doc" (or possibly
"hanzim.doc.gz"), which may be either in "/usr/local/doc",
"/usr/local/share/doc", "/usr/share/doc", "/usr/local/doc", or "/usr/doc"
depending on the idiosyncrasies of your particular distribution and
installation.
.PP
.\" TeX users may be more comfortable with the \fB<whatever>\fP and
.\" \fI<whatever>\fP escape sequences to invode bold face and italics, 
.\" respectively.
.SH OPTIONS
A summary of options is included below.
For a complete description, see the 'hanzim.doc' file referred to above.
.TP
.B \-small
Set up the display for a small (640x480) screen.
.TP
.B \-medium
Set up the display for a medium (800x600) screen.
.TP
.B \-large
Set up the display for a large (1024x768 and above) screen.  This is the
default.
.TP
.B \-simplified
Use Simplified Chinese characters at startup.  This is the default.
.TP
.B \-traditional
Use Traditional Chinese characters at startup.
.TP
.B \-pinyin
Force use of Pinyin pronunciation display even when using Traditional Chinese
characters.  Default is to use Zhuyin Fuhao (Bopomofo) for Traditional, Pinyin
for Simplified.
.TP
.B \-bopomofo
Force use of Zhuyin Fuhao (Bopomofo) pronunciation display even when using
Simplified Chinese characters.  Default is to use Pinyin for Simplified,
Zhuyin Fuhao (Bopomofo) for Traditional.
.TP
.B \-hidepron
Deactivate display of pinyin in the lower text panels, and make the overall
application window smaller.  ('Ctrl-p' or 'Alt-p' will toggle this when
running.)
.TP
.B \-db \fIdir\fP
Specifies the location of data files.  Default for most installations is
either '/usr/local/lib/hanzim' or '/usr/lib/hanzim'.  This overrides the
environment variable HANZIM_LIB, which in turn overrides the compiled-in
default.
.TP
.B \-buildDB
A special option to rebuild the binary compounds database.  This is run on
install and should be re-run whenever the 'cidian' file is replaced (see
hanzim.doc).  Currently it does not work in conjunction with the '\-db'
option; if you need to rebuild a database in a different directory, just
remove the file 'hcompound.dat' there and then run the program with the '\-db'
option only and \fBNOT\fP '\-buildDB'.
.TP
.B \-verbose
Print various diagnostic and descriptive information on startup.
.TP
.B \-quiet
Don't print any startup information.
.TP
.B \-debug
Operate in interactive (tclsh prompt) mode; implies -verbose.
.TP
.B \-help
Print out a summary of the command-line options.
.SH FILES
Requires the files "hanwin.tcl", "hanzim.fonts", "zidianf.gb", "zidianfl.b5",
"cidianf.gb", "bushou.gb", "parts.gb" to be installed in an accessible
directory specified by the -db command line option, the HANZIM_LIB
environment variable, or a compiled-in default, in that order of preference.
.SH SEE ALSO
.BR hanzim.doc
.SH AUTHOR
This manual page was written by Roger So <rogerso@sis.dhs.org>, for the Debian
GNU/Linux system and subsequently modified by Adrian Robert
<arobert@cogsci.ucsd.edu> (the original author) for more general distribution
with hanzim.
