#include <stdlib.h>
#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/Xos.h>
#include <Imlib2.h>
#define Xdepth	 (DefaultDepth(Xdisplay, screen))

Display *Xdisplay;
Window Xroot;
int screen, w, h, x, y;
Pixmap p = None, temp_pmap = None, m = None;
char *displayname = NULL;
Screen *scr;
XGCValues gcv;
GC gc;

void set_pixmap_property(Pixmap p)
{
	Atom prop_root, prop_esetroot, type;
	int format;
	unsigned long length, after;
	unsigned char *data_root, *data_esetroot;

	prop_root = XInternAtom(Xdisplay, "_XROOTPMAP_ID", True);
	prop_esetroot = XInternAtom(Xdisplay, "ESETROOT_PMAP_ID", True);

	if (prop_root != None && prop_esetroot != None) {
		XGetWindowProperty(Xdisplay, Xroot, prop_root, 0L, 1L, False, AnyPropertyType,
				&type, &format, &length, &after, &data_root);
		if (type == XA_PIXMAP) {
			XGetWindowProperty(Xdisplay, Xroot, prop_esetroot, 0L, 1L, False, AnyPropertyType,
					&type, &format, &length, &after, &data_esetroot);
			if (data_root && data_esetroot) {

				if (type == XA_PIXMAP && *((Pixmap *) data_root) == *((Pixmap *) data_esetroot)) {
					XKillClient(Xdisplay, *((Pixmap *) data_root));
				}
			}
		}
	}
	/* This will locate the property, creating it if it doesn't exist */
	prop_root = XInternAtom(Xdisplay, "_XROOTPMAP_ID", False);
	prop_esetroot = XInternAtom(Xdisplay, "ESETROOT_PMAP_ID", False);

	/* The call above should have created it.  If that failed, we can't continue. */
	if (prop_root == None || prop_esetroot == None) {
		fprintf(stderr, "Esetroot:  creation of pixmap property failed.\n");
		exit(1);
	}
	XChangeProperty(Xdisplay, Xroot, prop_root, XA_PIXMAP, 32, PropModeReplace,
			(unsigned char *) &p, 1);
	XChangeProperty(Xdisplay, Xroot, prop_esetroot, XA_PIXMAP, 32, PropModeReplace,
			(unsigned char *) &p, 1);

	XSetCloseDownMode(Xdisplay, RetainPermanent);
	XFlush(Xdisplay);
}

void initXconnection(void) {
  displayname = getenv("DISPLAY");
  if (!displayname) {displayname = ":0.0";}
  if ((Xdisplay = XOpenDisplay(displayname)) == 0) {
    fprintf(stderr, "Unable to open display: %s\n",displayname);
    exit(1);
  }
  screen = DefaultScreen(Xdisplay);
  Xroot = RootWindow(Xdisplay, screen);
  scr = ScreenOfDisplay(Xdisplay, screen);

imlib_context_set_display(Xdisplay);
imlib_context_set_visual(DefaultVisual(Xdisplay, DefaultScreen(Xdisplay)));

  
p = XCreatePixmap(Xdisplay, Xroot, scr->width, scr->height, Xdepth);
gcv.foreground = gcv.background = BlackPixel(Xdisplay, screen);
gc = XCreateGC(Xdisplay, p, 0, &gcv);
XFillRectangle(Xdisplay, p, gc, 0, 0, scr->width, scr->height);

}

void dumpToScreen(void){

    imlib_context_set_drawable(Xroot);
    imlib_render_pixmaps_for_whole_image_at_size(&temp_pmap, &m, scr->width, scr->height);
if (temp_pmap != None) {
    if (m) {
      XFreePixmap(Xdisplay, m);
      m = None;
    }
    XSetTile(Xdisplay, gc, temp_pmap);
    XSetTSOrigin(Xdisplay, gc, x, y);
    XSetFillStyle(Xdisplay, gc, FillTiled);
      XFillRectangle(Xdisplay, p, gc, x, y, scr->width, scr->height);
    set_pixmap_property(p);
    XFlush(Xdisplay);
    XSetWindowBackgroundPixmap(Xdisplay, Xroot, p);
    XClearWindow(Xdisplay, Xroot);
    XFlush(Xdisplay);
  }
}

